/*
 * Decompiled with CFR 0.152.
 */
package org.ton.adnl.client;

import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.StringsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.ton.crypto.HexKt;
import org.ton.crypto.Sha256Kt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B \b\u0016\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB%\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0005R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/ton/adnl/client/AdnlPacket;", "", "block", "Lkotlin/Function1;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "payload", "Lio/ktor/utils/io/core/ByteReadPacket;", "nonce", "", "(Lio/ktor/utils/io/core/ByteReadPacket;[B)V", "length", "", "hash", "(I[BLio/ktor/utils/io/core/ByteReadPacket;[B)V", "getHash", "()[B", "getLength", "()I", "getNonce", "getPayload", "()Lio/ktor/utils/io/core/ByteReadPacket;", "isValid", "", "toString", "", "verify", "ton-kotlin-adnl"})
public final class AdnlPacket {
    private final int length;
    @NotNull
    private final byte[] nonce;
    @NotNull
    private final ByteReadPacket payload;
    @NotNull
    private final byte[] hash;

    public AdnlPacket(int length, @NotNull byte[] nonce, @NotNull ByteReadPacket payload, @NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        this.length = length;
        this.nonce = nonce;
        this.payload = payload;
        this.hash = hash;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final byte[] getNonce() {
        return this.nonce;
    }

    @NotNull
    public final ByteReadPacket getPayload() {
        return this.payload;
    }

    @NotNull
    public final byte[] getHash() {
        return this.hash;
    }

    public AdnlPacket(@NotNull Function1<? super BytePacketBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BytePacketBuilder bytePacketBuilder = new BytePacketBuilder(null, 1, null);
        block.invoke((Object)bytePacketBuilder);
        this(bytePacketBuilder.build(), null, 2, null);
    }

    public AdnlPacket(@NotNull ByteReadPacket payload, @NotNull byte[] nonce) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        byte[][] byArrayArray = new byte[][]{nonce, StringsKt.readBytes$default((ByteReadPacket)payload.copy(), (int)0, (int)1, null)};
        this((int)payload.getRemaining() + nonce.length + 32, nonce, payload, Sha256Kt.sha256((byte[][])byArrayArray));
    }

    public /* synthetic */ AdnlPacket(ByteReadPacket byteReadPacket, byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            byArray = Random.Default.nextBytes(32);
        }
        this(byteReadPacket, byArray);
    }

    public final void verify() {
        byte[] payloadBytes = StringsKt.readBytes$default((ByteReadPacket)this.payload.copy(), (int)0, (int)1, null);
        int actualLength = (int)this.payload.getRemaining() + this.nonce.length + 32;
        if (!(this.length == actualLength)) {
            boolean bl = false;
            String string = "length mismatch, expected: " + this.length + " actual: " + actualLength + '\n' + this;
            throw new IllegalStateException(string.toString());
        }
        byte[][] byArrayArray = new byte[][]{this.nonce, payloadBytes};
        byte[] calculatedHash = Sha256Kt.sha256((byte[][])byArrayArray);
        if (!Arrays.equals(this.hash, calculatedHash)) {
            boolean bl = false;
            byte[] $this$encodeHex$iv = calculatedHash;
            boolean $i$f$encodeHex = false;
            StringBuilder stringBuilder = new StringBuilder().append("hash mismatch, expected: ").append(HexKt.hex((byte[])$this$encodeHex$iv)).append(" actual: ");
            $this$encodeHex$iv = this.hash;
            $i$f$encodeHex = false;
            String string = stringBuilder.append(HexKt.hex((byte[])$this$encodeHex$iv)).append('\n').append(this).toString();
            throw new IllegalStateException(string.toString());
        }
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.verify();
            bl = true;
        }
        catch (IllegalStateException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String toString() {
        byte[] $this$encodeHex$iv = this.nonce;
        boolean $i$f$encodeHex = false;
        StringBuilder stringBuilder = new StringBuilder().append("AdnlPacket(\n  length=").append(this.length).append("\n  nonce=").append(HexKt.hex((byte[])$this$encodeHex$iv)).append("\n  payload=");
        $this$encodeHex$iv = StringsKt.readBytes$default((ByteReadPacket)this.payload.copy(), (int)0, (int)1, null);
        $i$f$encodeHex = false;
        StringBuilder stringBuilder2 = stringBuilder.append(HexKt.hex((byte[])$this$encodeHex$iv)).append("\n  hash=");
        $this$encodeHex$iv = this.hash;
        $i$f$encodeHex = false;
        return stringBuilder2.append(HexKt.hex((byte[])$this$encodeHex$iv)).append("\n)").toString();
    }
}

