/*
 * Decompiled with CFR 0.152.
 */
package org.ton.adnl.node;

import io.ktor.util.collections.ConcurrentMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.adnl.node.AdnlPeer;
import org.ton.api.adnl.AdnlAddress;
import org.ton.api.adnl.AdnlAddressList;
import org.ton.api.adnl.AdnlNode;
import org.ton.api.pk.PrivateKey;
import org.ton.api.pub.PublicKey;
import org.ton.logger.Logger;
import org.ton.logger.PrintLnLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0010R\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/ton/adnl/node/AdnlNodeImpl;", "Lkotlinx/coroutines/CoroutineScope;", "privateKey", "Lorg/ton/api/pk/PrivateKey;", "scope", "Lkotlin/coroutines/CoroutineContext;", "logger", "Lorg/ton/logger/Logger;", "(Lorg/ton/api/pk/PrivateKey;Lkotlin/coroutines/CoroutineContext;Lorg/ton/logger/Logger;)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getLogger", "()Lorg/ton/logger/Logger;", "peers", "Lio/ktor/util/collections/ConcurrentMap;", "Lorg/ton/api/pub/PublicKey;", "Lorg/ton/api/adnl/AdnlNode;", "getPrivateKey", "()Lorg/ton/api/pk/PrivateKey;", "publicKey", "getPublicKey", "()Lorg/ton/api/pub/PublicKey;", "publicKey$delegate", "Lkotlin/Lazy;", "supervisorJob", "Lkotlinx/coroutines/CompletableJob;", "addPeer", "", "Lorg/ton/api/adnl/AdnlAddress;", "peer", "Lorg/ton/adnl/node/AdnlPeer;", "removePeer", "", "adnlNode", "ton-kotlin-adnl"})
public final class AdnlNodeImpl
implements CoroutineScope {
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CompletableJob supervisorJob;
    @NotNull
    private final ConcurrentMap<PublicKey, AdnlNode> peers;
    @NotNull
    private final Lazy publicKey$delegate;
    @NotNull
    private final CoroutineContext coroutineContext;

    public AdnlNodeImpl(@NotNull PrivateKey privateKey, @NotNull CoroutineContext scope, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.privateKey = privateKey;
        this.logger = logger;
        this.supervisorJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.peers = new ConcurrentMap(0, 1, null);
        this.publicKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PublicKey>(this){
            final /* synthetic */ AdnlNodeImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PublicKey invoke() {
                return this.this$0.getPrivateKey().publicKey();
            }
        }));
        this.coroutineContext = scope.plus((CoroutineContext)this.supervisorJob);
    }

    public /* synthetic */ AdnlNodeImpl(PrivateKey privateKey, CoroutineContext coroutineContext2, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineContext2 = (CoroutineContext)new CoroutineName("ADNL Node");
        }
        if ((n & 4) != 0) {
            logger = (Logger)new PrintLnLogger("ADNL", null, 2, null);
        }
        this(privateKey, coroutineContext2, logger);
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        Lazy lazy = this.publicKey$delegate;
        return (PublicKey)lazy.getValue();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Nullable
    public final List<AdnlAddress> addPeer(@NotNull AdnlPeer peer) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        AdnlNode adnlNode = peer.getNode();
        if (Intrinsics.areEqual((Object)adnlNode.getId(), (Object)this.privateKey.publicKey())) {
            return null;
        }
        AdnlNode currentIdNode = (AdnlNode)this.peers.get((Object)adnlNode.getId());
        if (currentIdNode != null) {
            List newAddressList = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)currentIdNode.getAddr_list().getAddrs(), (Iterable)adnlNode.getAddr_list().getAddrs()));
            ((Map)this.peers).put(adnlNode.getId(), AdnlNode.copy$default((AdnlNode)adnlNode, null, (AdnlAddressList)AdnlAddressList.copy$default((AdnlAddressList)adnlNode.getAddr_list(), (List)CollectionsKt.distinct((Iterable)newAddressList), (int)0, (int)0, (int)0, (int)0, (int)30, null), (int)1, null));
            sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)adnlNode.getAddr_list())), (Function1)((Function1)new Function1<AdnlAddress, Boolean>(currentIdNode){
                final /* synthetic */ AdnlNode $currentIdNode;
                {
                    this.$currentIdNode = $currentIdNode;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull AdnlAddress address) {
                    Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                    return !this.$currentIdNode.getAddr_list().contains((Object)address);
                }
            }));
        } else {
            ((Map)this.peers).put(adnlNode.getId(), adnlNode);
            sequence = CollectionsKt.asSequence((Iterable)((Iterable)adnlNode.getAddr_list()));
        }
        List newAddresses2 = SequencesKt.toList((Sequence)sequence);
        this.logger.debug((Function0)new Function0<String>((List<? extends AdnlAddress>)newAddresses2, adnlNode, this){
            final /* synthetic */ List<AdnlAddress> $newAddresses;
            final /* synthetic */ AdnlNode $adnlNode;
            final /* synthetic */ AdnlNodeImpl this$0;
            {
                this.$newAddresses = $newAddresses;
                this.$adnlNode = $adnlNode;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Added ADNL peer with addresses: " + this.$newAddresses + ", id: " + this.$adnlNode.getId() + " to: " + this.this$0.getPublicKey();
            }
        });
        return newAddresses2;
    }

    public final void removePeer(@NotNull AdnlPeer peer) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        this.removePeer(peer.getNode());
    }

    public final void removePeer(@NotNull AdnlNode adnlNode) {
        Intrinsics.checkNotNullParameter((Object)adnlNode, (String)"adnlNode");
        this.removePeer(adnlNode.getId());
    }

    public final void removePeer(@NotNull PublicKey publicKey2) {
        Intrinsics.checkNotNullParameter((Object)publicKey2, (String)"publicKey");
        if (this.peers.remove((Object)publicKey2) == null) {
            this.logger.warn((Function0)new Function0<String>(publicKey2){
                final /* synthetic */ PublicKey $publicKey;
                {
                    this.$publicKey = $publicKey;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Try to remove peer: " + this.$publicKey + " from unknown node: " + this.$publicKey;
                }
            });
        }
    }
}

