/*
 * Decompiled with CFR 0.152.
 */
package org.ton.adnl.node;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.adnl.node.AdnlChannelId;
import org.ton.api.adnl.AdnlIdShort;
import org.ton.api.pk.PrivateKeyAes;
import org.ton.api.pub.PublicKeyAes;
import org.ton.crypto.Decryptor;
import org.ton.crypto.Encryptor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0096\u0001J\u001b\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/ton/adnl/node/AdnlChannel;", "Lorg/ton/crypto/Encryptor;", "Lorg/ton/crypto/Decryptor;", "decryptorKey", "Lorg/ton/api/pk/PrivateKeyAes;", "encryptorKey", "Lorg/ton/api/pub/PublicKeyAes;", "(Lorg/ton/api/pk/PrivateKeyAes;Lorg/ton/api/pub/PublicKeyAes;)V", "inputId", "Lorg/ton/adnl/node/AdnlChannelId;", "getInputId", "()Lorg/ton/adnl/node/AdnlChannelId;", "outputId", "getOutputId", "decrypt", "", "data", "encrypt", "equals", "", "other", "", "hashCode", "", "sign", "message", "verify", "signature", "Companion", "ton-kotlin-adnl"})
public final class AdnlChannel
implements Encryptor,
Decryptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrivateKeyAes decryptorKey;
    @NotNull
    private final PublicKeyAes encryptorKey;
    @NotNull
    private final AdnlChannelId inputId;
    @NotNull
    private final AdnlChannelId outputId;

    public AdnlChannel(@NotNull PrivateKeyAes decryptorKey, @NotNull PublicKeyAes encryptorKey) {
        Intrinsics.checkNotNullParameter((Object)decryptorKey, (String)"decryptorKey");
        Intrinsics.checkNotNullParameter((Object)encryptorKey, (String)"encryptorKey");
        this.decryptorKey = decryptorKey;
        this.encryptorKey = encryptorKey;
        this.inputId = new AdnlChannelId(this.decryptorKey);
        this.outputId = new AdnlChannelId(this.encryptorKey);
    }

    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.encryptorKey.encrypt(data);
    }

    public boolean verify(@NotNull byte[] message, @Nullable byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.encryptorKey.verify(message, signature);
    }

    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.decryptorKey.decrypt(data);
    }

    @NotNull
    public byte[] sign(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.decryptorKey.sign(message);
    }

    @NotNull
    public final AdnlChannelId getInputId() {
        return this.inputId;
    }

    @NotNull
    public final AdnlChannelId getOutputId() {
        return this.outputId;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdnlChannel)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outputId, (Object)((AdnlChannel)other).outputId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.inputId, (Object)((AdnlChannel)other).inputId);
    }

    public int hashCode() {
        int result = this.outputId.hashCode();
        result = 31 * result + this.inputId.hashCode();
        return result;
    }

    @JvmStatic
    @NotNull
    public static final AdnlChannel of(@NotNull byte[] secret, @NotNull AdnlIdShort localId, @NotNull AdnlIdShort remoteId) {
        return Companion.of(secret, localId, remoteId);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/ton/adnl/node/AdnlChannel$Companion;", "", "()V", "of", "Lorg/ton/adnl/node/AdnlChannel;", "secret", "", "localId", "Lorg/ton/api/adnl/AdnlIdShort;", "remoteId", "ton-kotlin-adnl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AdnlChannel of(@NotNull byte[] secret, @NotNull AdnlIdShort localId, @NotNull AdnlIdShort remoteId) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Intrinsics.checkNotNullParameter((Object)localId, (String)"localId");
            Intrinsics.checkNotNullParameter((Object)remoteId, (String)"remoteId");
            int compare = localId.compareTo((Object)remoteId);
            PrivateKeyAes decryptorKey = null;
            PublicKeyAes encryptorKey = null;
            if (compare == 0) {
                decryptorKey = new PrivateKeyAes(secret);
                encryptorKey = new PublicKeyAes(secret);
            } else {
                byte[] revSecret = ArraysKt.reversedArray((byte[])secret);
                if (compare < 0) {
                    decryptorKey = new PrivateKeyAes(secret);
                    encryptorKey = new PublicKeyAes(revSecret);
                } else {
                    decryptorKey = new PrivateKeyAes(revSecret);
                    encryptorKey = new PublicKeyAes(secret);
                }
            }
            return new AdnlChannel(decryptorKey, encryptorKey);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

