/*
 * Decompiled with CFR 0.152.
 */
package org.ton.bitstring;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.bitstring.BitString;
import org.ton.bitstring.BitStringKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0011\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\fH\u0096\u0002J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/ton/bitstring/ByteArrayBitStringImpl;", "Lorg/ton/bitstring/BitString;", "length", "", "bytes", "", "(I[B)V", "getLength", "()I", "compareTo", "other", "equals", "", "", "get", "index", "hashCode", "set", "", "bit", "toBooleanArray", "", "toByteArray", "toString", "", "ton-bitstring"})
public final class ByteArrayBitStringImpl
implements BitString {
    private final int length;
    @NotNull
    private final byte[] bytes;

    public ByteArrayBitStringImpl(int length, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.length = length;
        this.bytes = bytes;
        BitStringKt.access$checkLength(this);
    }

    public /* synthetic */ ByteArrayBitStringImpl(int n, byte[] byArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1023;
        }
        if ((n2 & 2) != 0) {
            byArray = new byte[n / 8 + (n % 8 == 0 ? 0 : 1)];
        }
        this(n, byArray);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void set(int index, int bit) {
        this.set(index, bit != 0);
    }

    @Override
    public void set(int index, boolean bit) {
        int $this$wordIndex$iv = index;
        boolean $i$f$getWordIndex = false;
        int wordIndex = $this$wordIndex$iv / 8 | 0;
        int $this$bitMask$iv = index;
        boolean $i$f$getBitMask = false;
        byte bitMask = (byte)(1 << 7 - $this$bitMask$iv % 8);
        this.bytes[wordIndex] = bit ? (byte)(this.bytes[wordIndex] | bitMask) : (byte)(this.bytes[wordIndex] & (byte)(~bitMask));
    }

    @Override
    public boolean get(int index) {
        int $this$wordIndex$iv = index;
        boolean $i$f$getWordIndex = false;
        int wordIndex = $this$wordIndex$iv / 8 | 0;
        int $this$bitMask$iv = index;
        boolean $i$f$getBitMask = false;
        byte bitMask = (byte)(1 << 7 - $this$bitMask$iv % 8);
        return (byte)(this.bytes[wordIndex] & bitMask) != 0;
    }

    @Override
    @NotNull
    public byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.bytes, this.bytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        return byArray;
    }

    @Override
    @NotNull
    public boolean[] toBooleanArray() {
        return CollectionsKt.toBooleanArray((Collection)CollectionsKt.toList((Iterable)this));
    }

    @Override
    public int compareTo(@NotNull BitString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int limit = Math.min(this.getLength(), other.getLength());
        int n = 0;
        while (n < limit) {
            boolean otherValue;
            int it = n++;
            boolean bl = false;
            boolean thisValue = this.get(it);
            if (thisValue == (otherValue = other.get(it))) continue;
            return thisValue ? 1 : -1;
        }
        return this.getLength() - other.getLength();
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int l = this.getLength() % 4;
        if (l == 0) {
            byte[] $this$forEach$iv = this.bytes;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String hex;
                byte element$iv;
                byte by = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String string = Integer.toString(by & 0xFF, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                Intrinsics.checkNotNullExpressionValue((Object)string.toUpperCase(Locale.ROOT), (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                stringBuilder.append(hex);
            }
            if (this.getLength() % 8 != 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        } else {
            char c;
            byte[] $this$forEach$iv = this.bytes;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String hex;
                byte element$iv;
                byte by = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String string = Integer.toString(by & 0xFF, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                Intrinsics.checkNotNullExpressionValue((Object)string.toUpperCase(Locale.ROOT), (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                stringBuilder.append(hex);
            }
            int $this$bitMask$iv = this.getLength();
            boolean $i$f$getBitMask = false;
            byte bitMask = (byte)(1 << 7 - $this$bitMask$iv % 8);
            byte value = (byte)(ArraysKt.last((byte[])this.bytes) | bitMask);
            String string = Integer.toString(value & 0xFF, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String hex = string;
            if (bitMask > 15) {
                c = Character.toUpperCase(StringsKt.first((CharSequence)hex));
                stringBuilder.setCharAt(StringsKt.getLastIndex((CharSequence)stringBuilder) - 1, c);
                stringBuilder.setCharAt(StringsKt.getLastIndex((CharSequence)stringBuilder), '_');
            } else {
                c = Character.toUpperCase(StringsKt.last((CharSequence)hex));
                stringBuilder.setCharAt(StringsKt.getLastIndex((CharSequence)stringBuilder), c);
                stringBuilder.append('_');
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.ton.bitstring.BitString");
        }
        BitString cfr_ignored_0 = (BitString)object2;
        if (this.getLength() != ((BitString)other).getLength()) {
            return false;
        }
        return !(other instanceof ByteArrayBitStringImpl ? !Arrays.equals(this.bytes, ((ByteArrayBitStringImpl)other).bytes) : !Arrays.equals(this.toBooleanArray(), ((BitString)other).toBooleanArray()));
    }

    public int hashCode() {
        int result = this.getLength();
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return BitString.DefaultImpls.isEmpty(this);
    }

    @Override
    @NotNull
    public Iterator<Boolean> iterator() {
        return BitString.DefaultImpls.iterator(this);
    }

    public ByteArrayBitStringImpl() {
        this(0, null, 3, null);
    }
}

