/*
 * Decompiled with CFR 0.152.
 */
package org.ton.bitstring;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ton.bitstring.BitString;
import org.ton.bitstring.BitStringKt;
import org.ton.bitstring.ByteArrayBitStringImpl;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00020\u000b\"\u00020\f\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u0012\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\tH\u0002\"\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u0005\u001a\u00020\u0002*\u00020\u00028\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"bitMask", "", "", "getBitMask", "(I)B", "wordIndex", "getWordIndex", "(I)I", "BitString", "Lorg/ton/bitstring/BitString;", "bits", "", "", "byteArray", "", "length", "hex", "", "", "checkLength", "", "ton-bitstring"})
public final class BitStringKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BitString BitString(@NotNull Iterable<Boolean> bits2) {
        Intrinsics.checkNotNullParameter(bits2, (String)"bits");
        List bitsList = CollectionsKt.toList(bits2);
        ByteArrayBitStringImpl bitString = new ByteArrayBitStringImpl(bitsList.size(), null, 2, null);
        Iterable $this$forEachIndexed$iv = bitsList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void bit;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            boolean bl = (Boolean)item$iv;
            int index = n;
            boolean bl2 = false;
            bitString.set(index, (boolean)bit);
        }
        return bitString;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BitString BitString(boolean ... bits2) {
        Intrinsics.checkNotNullParameter((Object)bits2, (String)"bits");
        ByteArrayBitStringImpl bitString = new ByteArrayBitStringImpl(bits2.length, null, 2, null);
        boolean[] $this$forEachIndexed$iv = bits2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (boolean item$iv : $this$forEachIndexed$iv) {
            void bit;
            int n = index$iv++;
            boolean bl = item$iv;
            int index = n;
            boolean bl2 = false;
            bitString.set(index, (boolean)bit);
        }
        return bitString;
    }

    @NotNull
    public static final BitString BitString(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        Iterable bits2 = SequencesKt.asIterable((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)StringsKt.asSequence((CharSequence)hex), (Function1)BitString.bits.1.INSTANCE)));
        return BitStringKt.BitString(bits2);
    }

    @NotNull
    public static final BitString BitString(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        return new ByteArrayBitStringImpl(byteArray.length * 8, byteArray);
    }

    @NotNull
    public static final BitString BitString(int length) {
        return new ByteArrayBitStringImpl(length, null, 2, null);
    }

    private static final int getWordIndex(int $this$wordIndex) {
        boolean $i$f$getWordIndex = false;
        return $this$wordIndex / 8 | 0;
    }

    private static final byte getBitMask(int $this$bitMask) {
        boolean $i$f$getBitMask = false;
        return (byte)(1 << 7 - $this$bitMask % 8);
    }

    private static final void checkLength(BitString $this$checkLength) {
        if (!($this$checkLength.getLength() <= 1023)) {
            boolean bl = false;
            String string = "BitString length expected: 0..1023, actual: " + $this$checkLength.getLength();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$checkLength(BitString $receiver) {
        BitStringKt.checkLength($receiver);
    }
}

