/*
 * Decompiled with CFR 0.152.
 */
package org.ton.bitstring;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.BooleanIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.ton.bitstring.BitStringKt;
import org.ton.bitstring.FiftHexBitStringSerializer;

@Serializable(with=FiftHexBitStringSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000b\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bg\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0002\u0016\u0017J\u0011\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005H\u00a6\u0002J\b\u0010\n\u001a\u00020\u0002H\u0016J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0096\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0002H\u00a6\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u00a6\u0002J\b\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0014\u001a\u00020\u0015H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/ton/bitstring/BitString;", "", "", "", "length", "", "getLength", "()I", "get", "index", "isEmpty", "iterator", "", "set", "", "bit", "toBooleanArray", "", "toByteArray", "", "toString", "", "BitStringIterator", "Companion", "ton-bitstring"})
public interface BitString
extends Iterable<Boolean>,
Comparable<BitString>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = org.ton.bitstring.BitString$Companion.$$INSTANCE;
    public static final int MAX_LENGTH = 1023;

    public int getLength();

    public void set(int var1, int var2);

    public void set(int var1, boolean var2);

    public boolean get(int var1);

    @NotNull
    public byte[] toByteArray();

    @NotNull
    public boolean[] toBooleanArray();

    public boolean isEmpty();

    @NotNull
    public String toString();

    @Override
    @NotNull
    public Iterator<Boolean> iterator();

    @JvmStatic
    @NotNull
    public static BitString of(boolean ... bits2) {
        return Companion.of(bits2);
    }

    @JvmStatic
    @NotNull
    public static BitString of(@NotNull Iterable<Boolean> bits2) {
        return Companion.of(bits2);
    }

    @JvmStatic
    @NotNull
    public static BitString of(@NotNull String hex) {
        return Companion.of(hex);
    }

    @JvmStatic
    @NotNull
    public static BitString of(@NotNull byte[] byteArray) {
        return Companion.of(byteArray);
    }

    @JvmStatic
    @NotNull
    public static BitString of(int length) {
        return Companion.of(length);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/ton/bitstring/BitString$BitStringIterator;", "Lkotlin/collections/BooleanIterator;", "bitString", "Lorg/ton/bitstring/BitString;", "(Lorg/ton/bitstring/BitString;)V", "getBitString", "()Lorg/ton/bitstring/BitString;", "index", "", "hasNext", "", "nextBoolean", "ton-bitstring"})
    public static final class BitStringIterator
    extends BooleanIterator {
        @NotNull
        private final BitString bitString;
        private int index;

        public BitStringIterator(@NotNull BitString bitString) {
            Intrinsics.checkNotNullParameter((Object)bitString, (String)"bitString");
            this.bitString = bitString;
        }

        @NotNull
        public final BitString getBitString() {
            return this.bitString;
        }

        public boolean hasNext() {
            return this.index < this.bitString.getLength();
        }

        public boolean nextBoolean() {
            int n = this.index;
            this.index = n + 1;
            return this.bitString.get(n);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/ton/bitstring/BitString$Companion;", "", "()V", "MAX_LENGTH", "", "of", "Lorg/ton/bitstring/BitString;", "bits", "", "", "byteArray", "", "length", "hex", "", "", "ton-bitstring"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int MAX_LENGTH = 1023;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BitString of(boolean ... bits2) {
            Intrinsics.checkNotNullParameter((Object)bits2, (String)"bits");
            return BitStringKt.BitString(Arrays.copyOf(bits2, bits2.length));
        }

        @JvmStatic
        @NotNull
        public final BitString of(@NotNull Iterable<Boolean> bits2) {
            Intrinsics.checkNotNullParameter(bits2, (String)"bits");
            return BitStringKt.BitString(bits2);
        }

        @JvmStatic
        @NotNull
        public final BitString of(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            return BitStringKt.BitString(hex);
        }

        @JvmStatic
        @NotNull
        public final BitString of(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            return BitStringKt.BitString(byteArray);
        }

        @JvmStatic
        @NotNull
        public final BitString of(int length) {
            return BitStringKt.BitString(length);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isEmpty(@NotNull BitString this_) {
            return this_.getLength() == 0;
        }

        @NotNull
        public static Iterator<Boolean> iterator(@NotNull BitString this_) {
            return (Iterator)((Object)new BitStringIterator(this_));
        }
    }
}

