/*
 * Decompiled with CFR 0.152.
 */
package org.tomfolga;

import hudson.maven.MavenModule;
import hudson.maven.ModuleDependency;
import hudson.views.ListViewColumn;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPomDependenciesColumn
extends ListViewColumn {
    private boolean onlyWithinGroupId;
    private String columnName;
    private static final Logger LOGGER = Logger.getLogger(AbstractPomDependenciesColumn.class.getName());

    public boolean isOnlyWithinGroupId() {
        return this.onlyWithinGroupId;
    }

    public AbstractPomDependenciesColumn(String columnName, boolean onlyWithinGroupId) {
        this.columnName = columnName;
        this.onlyWithinGroupId = onlyWithinGroupId;
    }

    public String getColumnCaption() {
        return this.columnName;
    }

    public boolean isMavenProject(Object module) {
        return module instanceof MavenModule;
    }

    public List<ModuleDependency> getDependencies(Object module) {
        LinkedList<ModuleDependency> dependencyStrings = new LinkedList<ModuleDependency>();
        if (this.isMavenProject(module)) {
            MavenModule mavenModule = (MavenModule)module;
            try {
                Field privateStringField = MavenModule.class.getDeclaredField("dependencies");
                privateStringField.setAccessible(true);
                Set fieldValue = (Set)privateStringField.get(mavenModule);
                for (ModuleDependency moduleDependency : fieldValue) {
                    if (this.onlyWithinGroupId) {
                        if (!mavenModule.getModuleName().groupId.equals(moduleDependency.getName().groupId)) continue;
                        dependencyStrings.add(moduleDependency);
                        continue;
                    }
                    dependencyStrings.add(moduleDependency);
                }
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
        return dependencyStrings;
    }
}

