/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.manager.FeatureManager;
import org.togglz.spring.web.FeaturesAreActive;

public class FeatureInterceptor
implements HandlerInterceptor {
    private final ConcurrentHashMap<HandlerMethod, AnnotationHolder<FeaturesAreActive>> annotations = new ConcurrentHashMap();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            AnnotationHolder<FeaturesAreActive> annotationHolder = this.annotations.get(handlerMethod);
            if (annotationHolder == null) {
                FeaturesAreActive foundAnnotation = FeatureInterceptor.handlerAnnotation(handlerMethod, FeaturesAreActive.class);
                this.annotations.putIfAbsent(handlerMethod, new AnnotationHolder<FeaturesAreActive>(foundAnnotation));
                annotationHolder = this.annotations.get(handlerMethod);
            }
            if (annotationHolder.hasAnnotation()) {
                FeaturesAreActive featuresAreActiveAnnotation = annotationHolder.getAnnotation();
                Set annotationFeatureNames = Stream.of(featuresAreActiveAnnotation.features()).collect(Collectors.toSet());
                FeatureManager featureManager = FeatureContext.getFeatureManager();
                if (!FeatureInterceptor.getFeatureNames(featureManager).containsAll(annotationFeatureNames)) {
                    throw new IllegalArgumentException("At least one given feature of '" + annotationFeatureNames + "' is not a feature!");
                }
                boolean allFeaturesOfAnnotationMatch = featureManager.getFeatures().stream().filter(feature -> annotationFeatureNames.contains(feature.name())).allMatch(arg_0 -> ((FeatureManager)featureManager).isActive(arg_0));
                if (!allFeaturesOfAnnotationMatch) {
                    int errorStatusCode = featuresAreActiveAnnotation.errorResponseStatus().value();
                    response.sendError(errorStatusCode);
                    return false;
                }
            }
        }
        return super.preHandle(request, response, handler);
    }

    protected static <A extends Annotation> A handlerAnnotation(HandlerMethod handlerMethod, Class<A> annotationClass) {
        Annotation annotation = handlerMethod.getMethodAnnotation(annotationClass);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), annotationClass);
        }
        return (A)annotation;
    }

    protected static Set<String> getFeatureNames(FeatureManager featureManager) {
        return featureManager.getFeatures().stream().map(Feature::name).collect(Collectors.toSet());
    }

    private static final class AnnotationHolder<A extends Annotation> {
        private final A annotation;

        public AnnotationHolder(A annotation) {
            this.annotation = annotation;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public boolean hasAnnotation() {
            return this.annotation != null;
        }
    }
}

