/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.mobile;

import javax.servlet.http.HttpServletRequest;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceType;
import org.springframework.mobile.device.DeviceUtils;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.servlet.util.HttpServletRequestHolder;

public class DeviceActivationStrategy
implements ActivationStrategy {
    static final String ID = "devicerollout";
    private static final String YES = "YES";

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Device Rollout";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create((String)DeviceType.NORMAL.name()).label("Turn this feature ON for desktop").matching("(?i)(YES|NO)").description("Feature will be off by default enter 'YES' in box above to enable"), ParameterBuilder.create((String)DeviceType.TABLET.name()).label("Turn this feature ON for Tablet").matching("(?i)(YES|NO)").description("Feature will be off by default enter 'YES' in box above to enable"), ParameterBuilder.create((String)DeviceType.MOBILE.name()).label("Turn this feature ON for Mobile").matching("(?i)(YES|NO)").description("Feature will be off by default enter 'YES' in box above to enable")};
    }

    public boolean isActive(FeatureState featureState, FeatureUser user) {
        HttpServletRequest request = HttpServletRequestHolder.get();
        if (request == null) {
            return false;
        }
        Device device = DeviceUtils.getCurrentDevice((HttpServletRequest)request);
        DeviceType deviceType = device.isMobile() ? DeviceType.MOBILE : (device.isTablet() ? DeviceType.TABLET : DeviceType.NORMAL);
        return YES.equalsIgnoreCase(featureState.getParameter(deviceType.name()));
    }
}

