/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.autoconfigure;

import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConfigurationCondition;
import org.togglz.console.TogglzConsoleServlet;
import org.togglz.spring.boot.autoconfigure.TogglzProperties;

@ConditionalOnWebApplication
@ConditionalOnClass(value={TogglzConsoleServlet.class})
public abstract class TogglzConsoleBaseConfiguration {
    private final TogglzProperties properties;

    protected TogglzConsoleBaseConfiguration(TogglzProperties properties) {
        this.properties = properties;
    }

    @Bean
    public ServletRegistrationBean togglzConsole() {
        String path = this.getContextPath() + this.properties.getConsole().getPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        TogglzConsoleServlet servlet = new TogglzConsoleServlet();
        servlet.setSecured(this.properties.getConsole().isSecured());
        return new ServletRegistrationBean((Servlet)servlet, new String[]{urlMapping});
    }

    protected String getContextPath() {
        return "";
    }

    public static class OnConsoleAndNotUseManagementPort
    extends OnConsoleEnabled {

        @ConditionalOnProperty(prefix="togglz.console", name={"use-management-port"}, havingValue="false")
        static class OnNotUseManagementPort {
            OnNotUseManagementPort() {
            }
        }
    }

    public static class OnConsoleAndUseManagementPort
    extends OnConsoleEnabled {

        @ConditionalOnProperty(prefix="togglz.console", name={"use-management-port"}, havingValue="true", matchIfMissing=true)
        static class OnUseManagementPort {
            OnUseManagementPort() {
            }
        }
    }

    static class OnConsoleEnabled
    extends AllNestedConditions {
        OnConsoleEnabled() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="togglz.console", name={"enabled"}, matchIfMissing=true)
        static class OnConsole {
            OnConsole() {
            }
        }
    }
}

