/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.mongodb;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.ReplaceOptions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class MongoStateRepository
implements StateRepository {
    protected static final String FIELD_FEATURE = "feature";
    protected static final String FIELD_ENABLED = "enabled";
    protected static final String FIELD_STRATEGY = "strategy";
    protected static final String FIELD_PARAMS = "params";
    protected final MongoClient mongoClient;
    protected final String dbname;
    protected final String collection;
    protected final WriteConcern writeConcern;

    private MongoStateRepository(Builder builder) {
        this.mongoClient = builder.client;
        this.dbname = builder.dbname;
        this.collection = builder.collection;
        this.writeConcern = builder.writeConcern;
    }

    public FeatureState getFeatureState(Feature feature) {
        Document result = (Document)this.togglzCollection().find((Bson)this.queryFor(feature)).first();
        if (result != null) {
            Object paramsValue;
            FeatureState state = new FeatureState(feature);
            boolean enabledValue = result.getBoolean((Object)FIELD_ENABLED, false);
            state.setEnabled(enabledValue);
            String strategyValue = result.getString((Object)FIELD_STRATEGY);
            if (strategyValue != null) {
                state.setStrategyId(strategyValue.trim());
            }
            if ((paramsValue = result.get((Object)FIELD_PARAMS)) instanceof Document) {
                Document params = (Document)paramsValue;
                for (String key : params.keySet()) {
                    state.setParameter(key, params.get((Object)key).toString().trim());
                }
            }
            return state;
        }
        return null;
    }

    public void setFeatureState(FeatureState featureState) {
        Document featureStateDocument = new Document().append(FIELD_FEATURE, (Object)featureState.getFeature().name()).append(FIELD_ENABLED, (Object)featureState.isEnabled());
        if (featureState.getStrategyId() != null) {
            featureStateDocument.append(FIELD_STRATEGY, (Object)featureState.getStrategyId());
        }
        if (featureState.getParameterNames().size() > 0) {
            Document params = new Document();
            for (String key : featureState.getParameterNames()) {
                params.append(key, (Object)featureState.getParameter(key));
            }
            featureStateDocument.append(FIELD_PARAMS, (Object)params);
        }
        Document query = this.queryFor(featureState.getFeature());
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        this.togglzCollection().replaceOne((Bson)query, (Object)featureStateDocument, replaceOptions);
    }

    protected Document queryFor(Feature feature) {
        return new Document(FIELD_FEATURE, (Object)feature.name());
    }

    protected MongoCollection togglzCollection() {
        MongoDatabase db = this.mongoClient.getDatabase(this.dbname);
        return db.getCollection(this.collection).withWriteConcern(this.writeConcern);
    }

    public static Builder newBuilder(MongoClient client, String dbname) {
        return new Builder(client, dbname);
    }

    public static class Builder {
        private final MongoClient client;
        private final String dbname;
        private String collection = "togglz";
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;

        public Builder(MongoClient client, String dbname) {
            this.client = client;
            this.dbname = dbname;
        }

        public Builder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = writeConcern;
            return this;
        }

        public MongoStateRepository build() {
            return new MongoStateRepository(this);
        }
    }
}

