/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class MongoStateRepository
implements StateRepository {
    protected static final String FIELD_FEATURE = "feature";
    protected static final String FIELD_ENABLED = "enabled";
    protected static final String FIELD_STRATEGY = "strategy";
    protected static final String FIELD_PARAMS = "params";
    protected final MongoClient mongoClient;
    protected final String dbname;
    protected final String collection;
    protected final String username;
    protected final char[] password;
    protected final WriteConcern writeConcert;

    private MongoStateRepository(Builder builder) {
        this.mongoClient = builder.client;
        this.dbname = builder.dbname;
        this.collection = builder.collection;
        this.username = builder.username;
        this.password = builder.password;
        this.writeConcert = builder.writeConcern;
    }

    public FeatureState getFeatureState(Feature feature) {
        DBObject result = this.togglzCollection().findOne(this.queryFor(feature));
        if (result != null) {
            Object paramsValue;
            Object strategyValue;
            FeatureState state = new FeatureState(feature);
            Object enabledValue = result.get(FIELD_ENABLED);
            if (enabledValue instanceof Boolean) {
                state.setEnabled(((Boolean)enabledValue).booleanValue());
            }
            if ((strategyValue = result.get(FIELD_STRATEGY)) != null) {
                state.setStrategyId(strategyValue.toString().trim());
            }
            if ((paramsValue = result.get(FIELD_PARAMS)) instanceof DBObject) {
                DBObject params = (DBObject)paramsValue;
                for (String key : params.keySet()) {
                    state.setParameter(key, params.get(key).toString().trim());
                }
            }
            return state;
        }
        return null;
    }

    public void setFeatureState(FeatureState featureState) {
        BasicDBObject obj = new BasicDBObject().append(FIELD_FEATURE, (Object)featureState.getFeature().name()).append(FIELD_ENABLED, (Object)featureState.isEnabled());
        if (featureState.getStrategyId() != null) {
            obj.append(FIELD_STRATEGY, (Object)featureState.getStrategyId());
        }
        if (featureState.getParameterNames().size() > 0) {
            BasicDBObject params = new BasicDBObject();
            for (String key : featureState.getParameterNames()) {
                params.append(key, (Object)featureState.getParameter(key));
            }
            obj.append(FIELD_PARAMS, (Object)params);
        }
        DBObject query = this.queryFor(featureState.getFeature());
        this.togglzCollection().update(query, (DBObject)obj, true, false);
    }

    protected DBObject queryFor(Feature feature) {
        return new BasicDBObject().append(FIELD_FEATURE, (Object)feature.name());
    }

    protected DBCollection togglzCollection() {
        DB db = this.mongoClient.getDB(this.dbname);
        db.setWriteConcern(this.writeConcert);
        if (this.username != null && this.password != null) {
            db.authenticate(this.username, this.password);
        }
        return db.getCollection(this.collection);
    }

    public static Builder newBuilder(MongoClient client, String dbname) {
        return new Builder(client, dbname);
    }

    public static class Builder {
        private final MongoClient client;
        private final String dbname;
        private String collection = "togglz";
        private String username = null;
        private char[] password = null;
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;

        public Builder(MongoClient client, String dbname) {
            this.client = client;
            this.dbname = dbname;
        }

        public Builder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder authentication(String username, String password) {
            return this.authentication(username, password.toCharArray());
        }

        public Builder authentication(String username, char[] password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = writeConcern;
            return this;
        }

        public MongoStateRepository build() {
            return new MongoStateRepository(this);
        }
    }
}

