/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.deltaspike.activation;

import java.util.List;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.togglz.core.activation.AbstractTokenizedActivationStrategy;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.user.FeatureUser;

public class DeltaSpikeProjectStageActivationStrategy
extends AbstractTokenizedActivationStrategy {
    public static final String ID = "deltaspike-project-stage";
    public static final String PARAM_STAGES = "stages";

    public String getId() {
        return ID;
    }

    public String getName() {
        return "DeltaSpike Project Stage";
    }

    protected boolean isActive(FeatureState featureState, FeatureUser user, List<AbstractTokenizedActivationStrategy.Token> tokens) {
        ProjectStage activeProjectStage = ProjectStageProducer.getInstance().getProjectStage();
        for (AbstractTokenizedActivationStrategy.Token token : tokens) {
            ProjectStage projectStage = ProjectStage.valueOf((String)token.getValue());
            if (activeProjectStage.equals(projectStage) == token.isNegated()) continue;
            return true;
        }
        return false;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create((String)PARAM_STAGES).label("Project Stages").description("A comma-separated list of stage names for which the feature should be active. A stage can be negated by prefixing the name with the NOT operator (!).")};
    }

    public String getTokenParameterName() {
        return PARAM_STAGES;
    }
}

