/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.googleclouddatastore.repository;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.util.Preconditions;
import org.togglz.googleclouddatastore.repository.NonIndexed;

public class GoogleCloudDatastoreStateRepository
implements StateRepository {
    static final String STRATEGY_PARAMS_VALUES = "strategyParamsValues";
    static final String STRATEGY_PARAMS_NAMES = "strategyParamsNames";
    static final String STRATEGY_ID = "strategyId";
    static final String ENABLED = "enabled";
    static final String KIND_DEFAULT = "FeatureToggle";
    private final Datastore datastore;
    private final KeyFactory keyFactory;

    @Inject
    public GoogleCloudDatastoreStateRepository(Datastore datastore) {
        this(datastore, KIND_DEFAULT);
    }

    @Inject
    public GoogleCloudDatastoreStateRepository(Datastore datastore, String kind) {
        this.datastore = datastore;
        this.keyFactory = (KeyFactory)this.datastore.newKeyFactory().setKind(kind);
    }

    public FeatureState getFeatureState(Feature feature) {
        Key key = this.createKey(feature);
        Entity featureEntity = this.datastore.get(key);
        return this.createFeatureState(feature, featureEntity);
    }

    private Key createKey(Feature feature) {
        return this.keyFactory.newKey(feature.name());
    }

    private FeatureState createFeatureState(Feature feature, Entity featureEntity) {
        if (featureEntity == null) {
            return null;
        }
        boolean enabled = featureEntity.getBoolean(ENABLED);
        FeatureState state = new FeatureState(feature, enabled);
        String strategyId = this.getStrategyId(featureEntity);
        state.setStrategyId(strategyId);
        List<Value<String>> names = this.valuesList(featureEntity, STRATEGY_PARAMS_NAMES);
        List<Value<String>> values = this.valuesList(featureEntity, STRATEGY_PARAMS_VALUES);
        Preconditions.checkState((names.size() == values.size() ? 1 : 0) != 0);
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i).get();
            String value = (String)values.get(i).get();
            state.setParameter(name, value);
        }
        return state;
    }

    private List<Value<String>> valuesList(Entity entity, String propertyName) {
        return entity.contains(propertyName) ? entity.getList(propertyName) : Collections.emptyList();
    }

    private String getStrategyId(Entity featureEntity) {
        String strategyId;
        if (featureEntity.contains(STRATEGY_ID) && (strategyId = featureEntity.getString(STRATEGY_ID)) != null && !strategyId.isEmpty()) {
            return strategyId.trim();
        }
        return null;
    }

    public void setFeatureState(FeatureState featureState) {
        Map params;
        Key key = this.createKey(featureState.getFeature());
        Entity.Builder builder = (Entity.Builder)Entity.newBuilder((Key)key).set(ENABLED, (Value)NonIndexed.valueOf(featureState.isEnabled()));
        if (featureState.getStrategyId() != null) {
            builder.set(STRATEGY_ID, (Value)NonIndexed.valueOf(featureState.getStrategyId()));
        }
        if ((params = featureState.getParameterMap()) != null && !params.isEmpty()) {
            ArrayList<StringValue> strategyParamsNames = new ArrayList<StringValue>(params.size());
            ArrayList<StringValue> strategyParamsValues = new ArrayList<StringValue>(params.size());
            for (String paramName : params.keySet()) {
                strategyParamsNames.add(NonIndexed.valueOf(paramName));
                strategyParamsValues.add(NonIndexed.valueOf((String)params.get(paramName)));
            }
            builder.set(STRATEGY_PARAMS_NAMES, strategyParamsNames);
            builder.set(STRATEGY_PARAMS_VALUES, strategyParamsValues);
        }
        this.datastore.put((FullEntity)builder.build());
    }
}

