/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.appengine.repository;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import java.io.Serializable;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class MemcacheStateRepository
implements StateRepository {
    private StateRepository delegate;
    private MemcacheService cache = MemcacheServiceFactory.getMemcacheService();
    private Expiration expiration = Expiration.byDeltaSeconds((int)3600);
    private static final String KEY_PREFIX = MemcacheStateRepository.class.getName();

    public MemcacheStateRepository(StateRepository delegate) {
        this.delegate = delegate;
    }

    public MemcacheStateRepository(StateRepository delegate, int ttlInSeconds) {
        this(delegate);
        this.expiration = Expiration.byDeltaMillis((int)ttlInSeconds);
    }

    public FeatureState getFeatureState(Feature feature) {
        CacheEntry entry = (CacheEntry)this.cache.get((Object)this.key(feature.name()));
        if (entry != null) {
            return entry.getState() != null ? entry.getState() : null;
        }
        FeatureState featureState = this.delegate.getFeatureState(feature);
        this.cache.put((Object)this.key(feature.name()), (Object)new CacheEntry(featureState), this.getExpiration());
        return featureState;
    }

    String key(String featureName) {
        return KEY_PREFIX + featureName;
    }

    private Expiration getExpiration() {
        return this.expiration;
    }

    public void setFeatureState(FeatureState featureState) {
        this.delegate.setFeatureState(featureState);
        this.cache.delete((Object)this.key(featureState.getFeature().name()));
    }

    private static class CacheEntry
    implements Serializable {
        private final FeatureState state;

        public CacheEntry(FeatureState state) {
            this.state = state;
        }

        public FeatureState getState() {
            return this.state;
        }
    }
}

