/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.s3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.util.FeatureStateStorageWrapper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.utils.IoUtils;

public class S3StateRepository
implements StateRepository {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final S3Client client;
    private final String bucketName;
    private final String keyPrefix;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;

    private S3StateRepository(Builder builder) {
        this.client = builder.client;
        this.bucketName = builder.bucketName;
        this.keyPrefix = builder.keyPrefix;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
    }

    public FeatureState getFeatureState(Feature feature) {
        try {
            String content;
            GetObjectRequest getObjectRequest;
            ResponseInputStream object;
            GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder().bucket(this.bucketName).key(this.keyPrefix + feature.name());
            if (this.sseCustomerAlgorithm != null) {
                requestBuilder = requestBuilder.sseCustomerAlgorithm(this.sseCustomerAlgorithm);
            }
            if (this.sseCustomerKey != null) {
                requestBuilder = requestBuilder.sseCustomerKey(this.sseCustomerKey);
            }
            if (this.sseCustomerKeyMD5 != null) {
                requestBuilder = requestBuilder.sseCustomerKeyMD5(this.sseCustomerKeyMD5);
            }
            if ((object = this.client.getObject(getObjectRequest = (GetObjectRequest)requestBuilder.build())) != null && !(content = IoUtils.toUtf8String((InputStream)object)).isEmpty()) {
                FeatureStateStorageWrapper wrapper = (FeatureStateStorageWrapper)this.objectMapper.reader().forType(FeatureStateStorageWrapper.class).readValue(content);
                return FeatureStateStorageWrapper.featureStateForWrapper((Feature)feature, (FeatureStateStorageWrapper)wrapper);
            }
        }
        catch (NoSuchKeyException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set the feature state", e);
        }
        return null;
    }

    public void setFeatureState(FeatureState featureState) {
        try {
            FeatureStateStorageWrapper storageWrapper = FeatureStateStorageWrapper.wrapperForFeatureState((FeatureState)featureState);
            String json = this.objectMapper.writeValueAsString((Object)storageWrapper);
            PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(this.bucketName).key(this.keyPrefix + featureState.getFeature().name());
            if (this.sseCustomerAlgorithm != null) {
                requestBuilder = requestBuilder.sseCustomerAlgorithm(this.sseCustomerAlgorithm);
            }
            if (this.sseCustomerKey != null) {
                requestBuilder = requestBuilder.sseCustomerKey(this.sseCustomerKey);
            }
            if (this.sseCustomerKeyMD5 != null) {
                requestBuilder = requestBuilder.sseCustomerKeyMD5(this.sseCustomerKeyMD5);
            }
            PutObjectRequest putObjectRequest = (PutObjectRequest)requestBuilder.build();
            RequestBody requestBody = RequestBody.fromString((String)json);
            this.client.putObject(putObjectRequest, requestBody);
        }
        catch (JsonProcessingException | AwsServiceException | SdkClientException e) {
            throw new RuntimeException("Failed to set the feature state", e);
        }
    }

    public static Builder newBuilder(S3Client client, String bucketName) {
        return new Builder(client, bucketName);
    }

    public static class Builder {
        private final S3Client client;
        private final String bucketName;
        private String keyPrefix = "togglz/";
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;

        public Builder(S3Client client, String bucketName) {
            this.client = client;
            this.bucketName = bucketName;
        }

        public Builder prefix(String keyPrefix) {
            this.keyPrefix = keyPrefix == null ? "" : keyPrefix;
            return this;
        }

        public Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public S3StateRepository build() {
            return new S3StateRepository(this);
        }
    }
}

