/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.liteloader;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderVersion;

public class LiteloaderVersionList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Map<String, LiteloaderVersion>> versions;

    public static LiteloaderVersionList fromJson(JSONObject json) {
        TreeMap<String, Map<String, LiteloaderVersion>> versions = new TreeMap<String, Map<String, LiteloaderVersion>>();
        JSONObject versionsJson = json.getJSONObject("versions");
        for (String mcversion : versionsJson.keySet()) {
            TreeMap<String, LiteloaderVersion> artefacts = new TreeMap<String, LiteloaderVersion>();
            JSONObject artefactsJson = versionsJson.getJSONObject(mcversion).optJSONObject("artefacts");
            if (artefactsJson == null) continue;
            JSONObject liteloaderArtefactsJson = artefactsJson.getJSONObject("com.mumfrey:liteloader");
            for (String artefactId : liteloaderArtefactsJson.keySet()) {
                JSONObject artefactJson = liteloaderArtefactsJson.getJSONObject(artefactId);
                String liteloaderVersion = artefactJson.getString("version");
                String file = artefactJson.optString("file", null);
                String md5 = artefactJson.optString("md5", null);
                String timestampStr = artefactJson.optString("timestamp", null);
                Long timestamp = timestampStr == null ? null : Long.valueOf(timestampStr);
                String tweakClass = artefactJson.optString("tweakClass", null);
                JSONArray librariesJson = artefactJson.optJSONArray("libraries");
                HashSet<JSONObject> libraries = null;
                if (librariesJson != null) {
                    libraries = new HashSet<JSONObject>();
                    for (int i = 0; i < librariesJson.length(); ++i) {
                        libraries.add(librariesJson.getJSONObject(i));
                    }
                }
                artefacts.put(artefactId, new LiteloaderVersion(mcversion, liteloaderVersion, file, md5, timestamp, tweakClass, Collections.unmodifiableSet(libraries)));
            }
            versions.put(mcversion, artefacts);
        }
        return new LiteloaderVersionList(versions);
    }

    public LiteloaderVersionList(Map<String, Map<String, LiteloaderVersion>> versions) {
        Objects.requireNonNull(versions);
        this.versions = versions;
    }

    public Map<String, Map<String, LiteloaderVersion>> getAllArtefacts() {
        return this.versions;
    }

    public Map<String, LiteloaderVersion> getArtefacts(String minecraftVersion) {
        return this.versions.get(minecraftVersion);
    }

    public LiteloaderVersion getArtefact(String minecraftVersion, String artefactId) {
        Map<String, LiteloaderVersion> artefacts = this.versions.get(minecraftVersion);
        if (artefacts != null) {
            return artefacts.get(artefactId);
        }
        return null;
    }

    public LiteloaderVersion getLatestArtefact(String minecraftVersion) {
        return this.getArtefact(minecraftVersion, "latest");
    }

    public String toString() {
        return "LiteloaderVersionList [" + this.versions + "]";
    }

    public int hashCode() {
        return Objects.hash(this.versions);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LiteloaderVersionList) {
            LiteloaderVersionList another = (LiteloaderVersionList)obj;
            return this.versions.equals(another.versions);
        }
        return false;
    }
}

