/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.liteloader;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONObject;

public class LiteloaderVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String minecraftVersion;
    private String liteloaderVersion;
    private String superVersion;
    private String file;
    private String md5;
    private Long timestamp;
    private String tweakClass;
    private transient Set<JSONObject> libraries;

    public LiteloaderVersion(String minecraftVersion, String liteloaderVersion, String file, String md5, Long timestamp, String tweakClass, Set<JSONObject> libraries) {
        this(minecraftVersion, liteloaderVersion, minecraftVersion, file, md5, timestamp, tweakClass, libraries);
    }

    public LiteloaderVersion(String minecraftVersion, String liteloaderVersion, String superVersion, String file, String md5, Long timestamp, String tweakClass, Set<JSONObject> libraries) {
        Objects.requireNonNull(minecraftVersion);
        Objects.requireNonNull(liteloaderVersion);
        Objects.requireNonNull(superVersion);
        this.minecraftVersion = minecraftVersion;
        this.liteloaderVersion = liteloaderVersion;
        this.superVersion = superVersion;
        this.file = file;
        this.md5 = md5;
        this.timestamp = timestamp;
        this.tweakClass = tweakClass;
        this.libraries = libraries;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getLiteloaderVersion() {
        return this.liteloaderVersion;
    }

    public String getSuperVersion() {
        return this.superVersion;
    }

    public String getVersionName() {
        return this.superVersion + "-LiteLoader" + this.minecraftVersion;
    }

    public String getFile() {
        return this.file;
    }

    public String getMd5() {
        return this.md5;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getTweakClass() {
        return this.tweakClass;
    }

    public Set<JSONObject> getLibraries() {
        return this.libraries;
    }

    public LiteloaderVersion customize(String superVersion) {
        return new LiteloaderVersion(this.minecraftVersion, this.liteloaderVersion, superVersion, this.file, this.md5, this.timestamp, this.tweakClass, this.libraries);
    }

    public String toString() {
        return this.getVersionName();
    }

    public int hashCode() {
        return Objects.hash(this.minecraftVersion, this.liteloaderVersion, this.superVersion, this.file, this.md5, this.timestamp, this.tweakClass, this.libraries);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LiteloaderVersion) {
            LiteloaderVersion another = (LiteloaderVersion)obj;
            return this.minecraftVersion.equals(another.minecraftVersion) && this.liteloaderVersion.equals(another.liteloaderVersion) && this.superVersion.equals(another.superVersion) && Objects.equals(this.file, another.file) && Objects.equals(this.md5, another.md5) && Objects.equals(this.timestamp, another.timestamp) && Objects.equals(this.tweakClass, another.tweakClass) && Objects.equals(this.libraries, another.libraries);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.libraries == null);
        if (this.libraries != null) {
            out.writeInt(this.libraries.size());
            for (JSONObject element : this.libraries) {
                out.writeUTF(element.toString());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!in.readBoolean()) {
            int size = in.readInt();
            HashSet<JSONObject> newLibraries = new HashSet<JSONObject>();
            for (int i = 0; i < size; ++i) {
                newLibraries.add(new JSONObject(in.readUTF()));
            }
            this.libraries = Collections.unmodifiableSet(newLibraries);
        } else {
            this.libraries = null;
        }
    }
}

