/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.liteloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.to2mbn.jmccc.mcdownloader.download.MemoryDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.ResultProcessor;
import org.to2mbn.jmccc.mcdownloader.download.combine.AbstractCombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.provider.AbstractMinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.ExtendedDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderVersion;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderVersionList;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.ResolvedLiteloaderVersion;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.FileUtils;

public class LiteloaderDownloadProvider
extends AbstractMinecraftDownloadProvider
implements ExtendedDownloadProvider {
    private MinecraftDownloadProvider upstreamProvider;

    public CombinedDownloadTask<LiteloaderVersionList> liteloaderVersionList() {
        return CombinedDownloadTask.single(new MemoryDownloadTask(this.liteloaderVersionListUrl()).andThen(new ResultProcessor<byte[], LiteloaderVersionList>(){

            @Override
            public LiteloaderVersionList process(byte[] arg) throws Exception {
                return LiteloaderVersionList.fromJson(new JSONObject(new String(arg, "UTF-8")));
            }
        }));
    }

    @Override
    public CombinedDownloadTask<String> gameVersionJson(final MinecraftDirectory mcdir, String version) {
        final ResolvedLiteloaderVersion liteloaderVersionInfo = ResolvedLiteloaderVersion.resolve(version);
        if (liteloaderVersionInfo == null) {
            return null;
        }
        return new CombinedDownloadTask<String>(){

            @Override
            public void execute(final CombinedDownloadContext<String> context) throws Exception {
                context.submit(LiteloaderDownloadProvider.this.liteloaderVersionList(), new AbstractCombinedDownloadCallback<LiteloaderVersionList>(){

                    @Override
                    public void done(final LiteloaderVersionList versionList) {
                        try {
                            context.submit(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    final LiteloaderVersion liteloaderVersion = versionList.getLatestArtefact(liteloaderVersionInfo.getMinecraftVersion()).customize(liteloaderVersionInfo.getSuperVersion());
                                    context.submit(LiteloaderDownloadProvider.this.upstreamProvider.gameVersionJson(mcdir, liteloaderVersion.getSuperVersion()), new AbstractCombinedDownloadCallback<String>(){

                                        @Override
                                        public void done(final String resolvedSuperVersion) {
                                            try {
                                                context.submit(new Callable<Void>(){

                                                    @Override
                                                    public Void call() throws Exception {
                                                        context.done(LiteloaderDownloadProvider.this.createLiteloaderVersion(mcdir, liteloaderVersion.customize(resolvedSuperVersion)));
                                                        return null;
                                                    }
                                                }, null, true);
                                            }
                                            catch (InterruptedException e) {
                                                Thread.currentThread().interrupt();
                                            }
                                        }
                                    }, true);
                                    return null;
                                }
                            }, null, true);
                        }
                        catch (InterruptedException e) {
                            context.cancelled();
                        }
                    }
                }, true);
            }
        };
    }

    @Override
    public void setUpstreamProvider(MinecraftDownloadProvider upstreamProvider) {
        this.upstreamProvider = upstreamProvider;
    }

    protected String createLiteloaderVersion(MinecraftDirectory mcdir, LiteloaderVersion liteloader) throws IOException {
        JSONObject versionjson;
        String superVersion = liteloader.getSuperVersion();
        String minecraftVersion = liteloader.getMinecraftVersion();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(mcdir.getVersionJson(superVersion))), "UTF-8");){
            versionjson = new JSONObject(new JSONTokener((Reader)reader));
        }
        String version = String.format("%s-LiteLoader%s", superVersion, minecraftVersion);
        String minecraftArguments = String.format("%s --tweakClass %s", versionjson.getString("minecraftArguments"), liteloader.getTweakClass());
        JSONArray libraries = new JSONArray();
        JSONObject liteloaderLibrary = new JSONObject();
        liteloaderLibrary.put("name", (Object)String.format("com.mumfrey:liteloader:%s", minecraftVersion));
        liteloaderLibrary.put("url", (Object)"http://dl.liteloader.com/versions/");
        libraries.put((Object)liteloaderLibrary);
        for (JSONObject library : liteloader.getLibraries()) {
            libraries.put((Object)library);
        }
        versionjson.put("inheritsFrom", (Object)superVersion);
        versionjson.put("minecraftArguments", (Object)minecraftArguments);
        versionjson.put("mainClass", (Object)"net.minecraft.launchwrapper.Launch");
        versionjson.put("id", (Object)version);
        versionjson.put("libraries", (Object)libraries);
        versionjson.remove("downloads");
        versionjson.remove("assets");
        versionjson.remove("assetIndex");
        File target = mcdir.getVersionJson(version);
        FileUtils.prepareWrite((File)target);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(target)), "UTF-8");){
            writer.write(versionjson.toString(4));
        }
        return version;
    }

    protected String liteloaderVersionListUrl() {
        return "http://dl.liteloader.com/versions/versions.json";
    }
}

