/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.forge;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeVersion;

public class ResolvedForgeVersion
implements Serializable {
    private static final Pattern FORGE_VERSION_PATTERN = Pattern.compile("^([\\w\\.\\-]+)-[Ff]orge\\1-([\\w\\.\\-]+)$");
    private static final Pattern OLD_FORGE_VERSION_PATTERN = Pattern.compile("^([\\w\\.\\-]+)-[Ff]orge([\\w\\.\\-]+)$");
    private static final Pattern SHORT_FORGE_VERSION_PATTERN = Pattern.compile("^([\\w\\.\\-]+)-([\\d\\.\\-]+)$");
    private static final long serialVersionUID = 1L;
    private String forgeVersion;
    private String minecraftVersion;

    public static ResolvedForgeVersion resolve(String version) {
        Matcher matcher = FORGE_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String forgeVersion = matcher.group(2);
            String mcversion = matcher.group(1);
            return new ResolvedForgeVersion(forgeVersion, mcversion);
        }
        matcher = OLD_FORGE_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String forgeVersion = matcher.group(2);
            String mcversion = matcher.group(1);
            return new ResolvedForgeVersion(forgeVersion, mcversion);
        }
        return null;
    }

    public static ResolvedForgeVersion resolveShort(String version) {
        Matcher matcher = SHORT_FORGE_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String forgeVersion = matcher.group(2);
            String mcversion = matcher.group(1);
            return new ResolvedForgeVersion(forgeVersion, mcversion);
        }
        return null;
    }

    public ResolvedForgeVersion(ForgeVersion version) {
        this(version.getForgeVersion(), version.getMinecraftVersion());
    }

    public ResolvedForgeVersion(String forgeVersion, String minecraftVersion) {
        this.forgeVersion = forgeVersion;
        this.minecraftVersion = minecraftVersion;
    }

    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getVersionName() {
        return this.minecraftVersion + "-" + this.forgeVersion;
    }

    public String toString() {
        return this.getVersionName();
    }

    public int hashCode() {
        return Objects.hash(this.forgeVersion, this.minecraftVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResolvedForgeVersion) {
            ResolvedForgeVersion another = (ResolvedForgeVersion)obj;
            return Objects.equals(this.forgeVersion, another.forgeVersion) && Objects.equals(this.minecraftVersion, another.minecraftVersion);
        }
        return false;
    }
}

