/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.forge;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeVersion;

public class ForgeVersionList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, ForgeVersion> versions;
    private Map<String, ForgeVersion> latests;
    private Map<String, ForgeVersion> recommendeds;
    private Map<String, ForgeVersion> forgeVersionMapping;
    private ForgeVersion latest;
    private ForgeVersion recommended;

    public static ForgeVersionList fromJson(JSONObject json) {
        TreeMap<Integer, ForgeVersion> versions = new TreeMap<Integer, ForgeVersion>();
        TreeMap<String, ForgeVersion> latests = new TreeMap<String, ForgeVersion>();
        TreeMap<String, ForgeVersion> recommendeds = new TreeMap<String, ForgeVersion>();
        TreeMap<String, ForgeVersion> forgeVersionMapping = new TreeMap<String, ForgeVersion>();
        ForgeVersion latest = null;
        ForgeVersion recommended = null;
        JSONObject versionsJson = json.getJSONObject("number");
        for (String strbuildnum : versionsJson.keySet()) {
            ForgeVersion version = ForgeVersion.fromJson(versionsJson.getJSONObject(strbuildnum));
            versions.put(version.getBuildNumber(), version);
            forgeVersionMapping.put(version.getForgeVersion(), version);
        }
        JSONObject promos = json.getJSONObject("promos");
        for (String key : promos.keySet()) {
            ForgeVersion version = (ForgeVersion)versions.get(promos.getInt(key));
            if ("latest".equals(key)) {
                latest = version;
                continue;
            }
            if ("recommended".equals(key)) {
                recommended = version;
                continue;
            }
            if (key.endsWith("-latest")) {
                latests.put(key.substring(0, key.length() - 7), version);
                continue;
            }
            if (!key.endsWith("-recommended")) continue;
            recommendeds.put(key.substring(0, key.length() - 12), version);
        }
        return new ForgeVersionList(Collections.unmodifiableMap(versions), Collections.unmodifiableMap(latests), Collections.unmodifiableMap(recommendeds), Collections.unmodifiableMap(forgeVersionMapping), latest, recommended);
    }

    public ForgeVersionList(Map<Integer, ForgeVersion> versions, Map<String, ForgeVersion> latests, Map<String, ForgeVersion> recommendeds, Map<String, ForgeVersion> forgeVersionMapping, ForgeVersion latest, ForgeVersion recommended) {
        Objects.requireNonNull(versions);
        Objects.requireNonNull(latests);
        Objects.requireNonNull(recommendeds);
        Objects.requireNonNull(forgeVersionMapping);
        this.versions = versions;
        this.latests = latests;
        this.recommendeds = recommendeds;
        this.forgeVersionMapping = forgeVersionMapping;
        this.latest = latest;
        this.recommended = recommended;
    }

    public Map<Integer, ForgeVersion> getVersions() {
        return this.versions;
    }

    public Map<String, ForgeVersion> getLatests() {
        return this.latests;
    }

    public Map<String, ForgeVersion> getRecommendeds() {
        return this.recommendeds;
    }

    public ForgeVersion getLatest() {
        return this.latest;
    }

    public ForgeVersion getLatest(String mcversion) {
        return this.latests.get(mcversion);
    }

    public ForgeVersion getRecommended() {
        return this.recommended;
    }

    public ForgeVersion getRecommended(String mcversion) {
        return this.recommendeds.get(mcversion);
    }

    public Map<String, ForgeVersion> getForgeVersionMapping() {
        return this.forgeVersionMapping;
    }

    public ForgeVersion get(int buildNumber) {
        return this.versions.get(buildNumber);
    }

    public ForgeVersion get(String forgeVersion) {
        return this.forgeVersionMapping.get(forgeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.versions, this.latests, this.recommendeds, this.forgeVersionMapping, this.latest, this.recommended);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForgeVersionList) {
            ForgeVersionList another = (ForgeVersionList)obj;
            return this.versions.equals(another.versions) && this.latests.equals(another.latests) && this.recommendeds.equals(another.recommendeds) && this.forgeVersionMapping.equals(another.forgeVersionMapping) && Objects.equals(this.latest, another.latest) && Objects.equals(this.recommended, another.recommended);
        }
        return false;
    }

    public String toString() {
        return String.format("ForgeVersionList [versions=%s, latests=%s, recommendeds=%s, forgeVersionMapping=%s, latest=%s, recommended=%s]", this.versions, this.latests, this.recommendeds, this.forgeVersionMapping, this.latest, this.recommended);
    }
}

