/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.forge;

import java.io.Serializable;
import java.util.Objects;
import org.json.JSONObject;

public class ForgeVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String minecraftVersion;
    private String forgeVersion;
    private int buildNumber;

    public static ForgeVersion fromJson(JSONObject json) {
        return new ForgeVersion(json.getString("mcversion"), json.getString("version"), json.getInt("build"));
    }

    public ForgeVersion(String minecraftVersion, String forgeVersion, int buildNumber) {
        Objects.requireNonNull(minecraftVersion);
        Objects.requireNonNull(forgeVersion);
        this.minecraftVersion = minecraftVersion;
        this.forgeVersion = forgeVersion;
        this.buildNumber = buildNumber;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getVersionName() {
        return this.minecraftVersion + "-forge" + this.minecraftVersion + "-" + this.forgeVersion;
    }

    public String toString() {
        return this.getVersionName();
    }

    public int hashCode() {
        return Objects.hash(this.minecraftVersion, this.forgeVersion, this.buildNumber);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForgeVersion) {
            ForgeVersion another = (ForgeVersion)obj;
            return this.minecraftVersion.equals(another.minecraftVersion) && this.forgeVersion.equals(this.forgeVersion) && this.buildNumber == another.buildNumber;
        }
        return false;
    }
}

