/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.to2mbn.jmccc.mcdownloader.download.ResultProcessor;
import org.to2mbn.jmccc.option.MinecraftDirectory;

public class InstallProfileProcessor
implements ResultProcessor<byte[], String> {
    private MinecraftDirectory mcdir;

    public InstallProfileProcessor(MinecraftDirectory mcdir) {
        this.mcdir = mcdir;
    }

    @Override
    public String process(byte[] arg) throws Exception {
        String version = null;
        try (ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(arg));){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                if ("install_profile.json".equals(entry.getName())) {
                    version = this.writeJson(this.processJson(new JSONObject(new JSONTokener((Reader)new InputStreamReader((InputStream)in, "UTF-8")))));
                    in.closeEntry();
                    break;
                }
                in.closeEntry();
            }
        }
        if (version == null) {
            throw new IllegalArgumentException("No install_profile.json has found");
        }
        return version;
    }

    protected JSONObject processJson(JSONObject installprofile) {
        return installprofile.getJSONObject("versionInfo");
    }

    private String writeJson(JSONObject json) throws IOException {
        String version = json.getString("id");
        File output = this.mcdir.getVersionJson(version);
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(output)), "UTF-8");){
            writer.write(json.toString(4));
        }
        return version;
    }
}

