/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.concurrent;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Cancelable;

public class AsyncFuture<V>
implements Future<V>,
Callback<V>,
Cancelable {
    private static final int RUNNING = 0;
    private static final int COMPLETING = 1;
    private static final int DONE = 2;
    private static final int FAILED = 3;
    private static final int CANCELLED = 4;
    private final Cancelable cancelable;
    private volatile Callback<V> callback;
    private final AtomicInteger state = new AtomicInteger(0);
    private volatile Throwable exception;
    private volatile V result;
    private final CountDownLatch latch = new CountDownLatch(1);

    public AsyncFuture() {
        this(null);
    }

    public AsyncFuture(Cancelable cancelable) {
        this.cancelable = cancelable;
    }

    public Callback<V> getCallback() {
        return this.callback;
    }

    public void setCallback(Callback<V> callback) {
        this.callback = callback;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.state.get() == 4;
    }

    @Override
    public boolean isDone() {
        return this.state.get() == 2;
    }

    public boolean isExceptional() {
        int s = this.state.get();
        return s == 3 || s == 4;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.isRunning()) {
            this.latch.await();
        }
        return this.getResult();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Objects.requireNonNull(unit);
        if (this.isRunning() && !this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.getResult();
    }

    @Override
    public void done(V result) {
        if (this.state.compareAndSet(0, 1)) {
            this.result = result;
            this.state.set(2);
            this.terminated();
            Callback<V> c = this.callback;
            if (c != null) {
                c.done(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable e) {
        Objects.requireNonNull(e);
        if (this.state.compareAndSet(0, 1)) {
            this.exception = e;
            this.state.set(3);
            this.terminated();
            this.cancelUnderlying();
            Callback<V> c = this.callback;
            if (c != null) {
                c.failed(e);
            }
        } else {
            while (this.state.get() == 1) {
                Thread.yield();
            }
            if (this.state.get() == 3 && this.exception != e) {
                assert (this.exception != null);
                Throwable throwable = this.exception;
                synchronized (throwable) {
                    for (Throwable e1 : this.exception.getSuppressed()) {
                        if (e1 != e) continue;
                        return;
                    }
                    this.exception.addSuppressed(e);
                }
            }
        }
    }

    @Override
    public void cancelled() {
        if (this.state.compareAndSet(0, 4)) {
            this.terminated();
            this.cancelUnderlying();
            Callback<V> c = this.callback;
            if (c != null) {
                c.cancelled();
            }
        }
    }

    private void terminated() {
        this.latch.countDown();
    }

    private V getResult() throws ExecutionException {
        switch (this.state.get()) {
            case 2: {
                return this.result;
            }
            case 3: {
                throw new ExecutionException(this.exception);
            }
            case 4: {
                throw new CancellationException();
            }
        }
        throw new IllegalStateException("not in a completed state");
    }

    private void cancelUnderlying() {
        if (this.cancelable != null) {
            this.cancelable.cancel(true);
        }
    }

    private boolean isRunning() {
        int s = this.state.get();
        return s == 0 || s == 1;
    }
}

