/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.combine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.to2mbn.jmccc.mcdownloader.download.DownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.DownloadCallbacks;
import org.to2mbn.jmccc.mcdownloader.download.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.Downloader;
import org.to2mbn.jmccc.mcdownloader.download.combine.AbstractCombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadCallbacks;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloader;
import org.to2mbn.jmccc.mcdownloader.download.combine.NullCombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CallbackAdapter;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CallbackAsyncFutureTask;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CallbackFutureTask;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callbacks;

public class CombinedDownloaderImpl
implements CombinedDownloader {
    private Executor executor;
    private Downloader downloader;
    private int defaultTries;
    private volatile boolean shutdown;
    private final ReadWriteLock globalRwlock = new ReentrantReadWriteLock();
    private final Set<Future<?>> tasks = Collections.newSetFromMap(new ConcurrentHashMap());

    public CombinedDownloaderImpl(Executor executor, Downloader downloader, int defaultTries) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(downloader);
        if (defaultTries < 1) {
            throw new IllegalArgumentException(String.valueOf(defaultTries));
        }
        this.executor = executor;
        this.downloader = downloader;
        this.defaultTries = defaultTries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> download(CombinedDownloadTask<T> downloadTask, CombinedDownloadCallback<T> callback, int tries) {
        Objects.requireNonNull(downloadTask);
        if (tries < 1) {
            throw new IllegalArgumentException("tries < 1");
        }
        CombinedAsyncTask<T> task = new CombinedAsyncTask<T>(downloadTask, callback == null ? new NullCombinedDownloadCallback() : callback, tries);
        Callback statusCallback = Callbacks.whatever(new TaskInactiver(task));
        if (callback != null) {
            statusCallback = Callbacks.group(statusCallback, callback);
        }
        task.setCallback(callback);
        Lock lock = this.globalRwlock.readLock();
        lock.lock();
        try {
            if (this.shutdown) {
                throw new RejectedExecutionException("The downloader has been shutdown.");
            }
            this.tasks.add(task);
            this.executor.execute(task);
        }
        finally {
            lock.unlock();
        }
        return task;
    }

    @Override
    public void shutdown() {
        Lock lock = this.globalRwlock.writeLock();
        lock.lock();
        try {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        finally {
            lock.unlock();
        }
        for (Future<?> task : this.tasks) {
            task.cancel(true);
        }
        this.executor = null;
        this.downloader = null;
    }

    @Override
    public <T> Future<T> download(CombinedDownloadTask<T> task, CombinedDownloadCallback<T> callback) {
        return this.download(task, callback, this.defaultTries);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    private class TaskInactiver
    implements Runnable {
        private final Future<?> future;

        public TaskInactiver(Future<?> future) {
            Objects.requireNonNull(future);
            this.future = future;
        }

        @Override
        public void run() {
            CombinedDownloaderImpl.this.tasks.remove(this.future);
        }
    }

    private class CombinedAsyncTask<T>
    extends CallbackAsyncFutureTask<T>
    implements CombinedDownloadContext<T> {
        private final CombinedDownloadTask<T> task;
        private final CombinedDownloadCallback<T> callback;
        private final int tries;
        private final SubtaskCountdownAction countdownAction = new SubtaskCountdownAction();
        private final SubtaskCounter subtaskCounter = new SubtaskCounter();

        public CombinedAsyncTask(CombinedDownloadTask<T> task, CombinedDownloadCallback<T> callback, int tries) {
            Objects.requireNonNull(task);
            Objects.requireNonNull(callback);
            if (tries < 1) {
                throw new IllegalArgumentException(String.valueOf(tries));
            }
            this.task = task;
            this.callback = callback;
            this.tries = tries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> Future<R> submit(Callable<R> task, Callback<R> injectedCallback, boolean fatal) throws InterruptedException {
            Objects.requireNonNull(task);
            CallbackFutureTask<R> futureTask = new CallbackFutureTask<R>(task);
            ArrayList callbacks = new ArrayList();
            CallbackAsyncFutureTask.FutureManager futureManager = this.createFutureManager();
            futureManager.setFuture(futureTask);
            callbacks.add(this.wrapCallback(futureManager));
            if (injectedCallback != null) {
                callbacks.add(this.wrapCallback(injectedCallback));
            }
            if (fatal) {
                callbacks.add(this.wrapCallback(new FatalSubtaskCallback()));
            }
            Callback countdownCallback = Callbacks.whatever(this.countdownAction);
            callbacks.add(this.wrapCallback(countdownCallback));
            futureTask.setCallback(Callbacks.group(callbacks));
            Lock lock = CombinedDownloaderImpl.this.globalRwlock.readLock();
            lock.lock();
            try {
                this.checkInterrupted();
                this.subtaskCounter.countUp();
                CombinedDownloaderImpl.this.executor.execute(futureTask);
            }
            finally {
                lock.unlock();
            }
            return futureTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> Future<R> submit(DownloadTask<R> task, DownloadCallback<R> injectedCallback, boolean fatal) throws InterruptedException {
            Future<R> future;
            DownloadCallback<R> foreignCallback;
            Objects.requireNonNull(task);
            ArrayList callbacks = new ArrayList();
            CallbackAsyncFutureTask.FutureManager futureManager = this.createFutureManager();
            callbacks.add(this.wrapDownloadCallback(DownloadCallbacks.fromCallback(futureManager)));
            if (injectedCallback != null) {
                callbacks.add(this.wrapDownloadCallback(injectedCallback));
            }
            if ((foreignCallback = this.callback.taskStart(task)) != null) {
                callbacks.add(this.wrapDownloadCallback(foreignCallback));
            }
            if (fatal) {
                callbacks.add(this.wrapDownloadCallback(DownloadCallbacks.fromCallback(new FatalSubtaskCallback())));
            }
            DownloadCallback countdownCallback = DownloadCallbacks.whatever(this.countdownAction);
            callbacks.add(this.wrapDownloadCallback(countdownCallback));
            Lock lock = CombinedDownloaderImpl.this.globalRwlock.readLock();
            lock.lock();
            try {
                this.checkInterrupted();
                this.subtaskCounter.countUp();
                future = CombinedDownloaderImpl.this.downloader.download(task, DownloadCallbacks.group(callbacks), this.tries);
                futureManager.setFuture(future);
            }
            finally {
                lock.unlock();
            }
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> Future<R> submit(CombinedDownloadTask<R> task, CombinedDownloadCallback<R> injectedCallback, boolean fatal) throws InterruptedException {
            Future<R> future;
            Objects.requireNonNull(task);
            ArrayList callbacks = new ArrayList();
            CallbackAsyncFutureTask.FutureManager futureManager = this.createFutureManager();
            callbacks.add(this.wrapCombinedDownloadCallback(CombinedDownloadCallbacks.fromCallback(futureManager)));
            if (injectedCallback != null) {
                callbacks.add(this.wrapCombinedDownloadCallback(injectedCallback));
            }
            callbacks.add(this.wrapCombinedDownloadCallback(new SubDownloadTaskMapper()));
            if (fatal) {
                callbacks.add(this.wrapCombinedDownloadCallback(CombinedDownloadCallbacks.fromCallback(new FatalSubtaskCallback())));
            }
            CombinedDownloadCallback countdownCallback = CombinedDownloadCallbacks.whatever(this.countdownAction);
            callbacks.add(this.wrapCombinedDownloadCallback(countdownCallback));
            Lock lock = CombinedDownloaderImpl.this.globalRwlock.readLock();
            lock.lock();
            try {
                this.checkInterrupted();
                this.subtaskCounter.countUp();
                future = CombinedDownloaderImpl.this.download(task, CombinedDownloadCallbacks.group(callbacks), this.tries);
                futureManager.setFuture(future);
            }
            finally {
                lock.unlock();
            }
            return future;
        }

        @Override
        public void awaitAllTasks(Callable<Void> callback) throws InterruptedException {
            this.checkInterrupted();
            this.subtaskCounter.awaitAllTasks(callback);
        }

        @Override
        protected void execute() throws Exception {
            this.task.execute(this);
        }

        @Override
        public void done(T result) {
            this.lifecycle().done(result);
        }

        @Override
        public void failed(Throwable e) {
            this.lifecycle().failed(e);
        }

        @Override
        public void cancelled() {
            this.lifecycle().cancelled();
        }

        private void checkInterrupted() throws InterruptedException {
            if (Thread.interrupted() || this.isExceptional() || CombinedDownloaderImpl.this.shutdown) {
                throw new InterruptedException();
            }
        }

        private <R> R wrapExceptionHandler(Class<?> clazz, R obj) {
            ExceptionCatcher handler = new ExceptionCatcher(obj);
            return (R)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
        }

        private <R> Callback<R> wrapCallback(Callback<R> callback) {
            return this.wrapExceptionHandler(Callback.class, callback);
        }

        private <R> DownloadCallback<R> wrapDownloadCallback(DownloadCallback<R> callback) {
            return this.wrapExceptionHandler(DownloadCallback.class, callback);
        }

        private <R> CombinedDownloadCallback<R> wrapCombinedDownloadCallback(CombinedDownloadCallback<R> callback) {
            return this.wrapExceptionHandler(CombinedDownloadCallback.class, callback);
        }

        private class SubDownloadTaskMapper<R>
        extends AbstractCombinedDownloadCallback<R> {
            private SubDownloadTaskMapper() {
            }

            @Override
            public <S> DownloadCallback<S> taskStart(DownloadTask<S> subtask) {
                return CombinedAsyncTask.this.callback.taskStart(subtask);
            }
        }

        private class FatalSubtaskCallback<R>
        extends CallbackAdapter<R> {
            private FatalSubtaskCallback() {
            }

            @Override
            public void failed(Throwable e) {
                CombinedAsyncTask.this.lifecycle().failed(e);
            }

            @Override
            public void cancelled() {
                CombinedAsyncTask.this.lifecycle().cancelled();
            }
        }

        private class SubtaskCountdownAction
        implements Runnable {
            private SubtaskCountdownAction() {
            }

            @Override
            public void run() {
                CombinedAsyncTask.this.subtaskCounter.countDown();
            }
        }

        private class SubtaskCounter {
            private final List<Callable<?>> taskWaitNodes = new Vector();
            private volatile int count = 0;

            private SubtaskCounter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void countUp() {
                SubtaskCounter subtaskCounter = this;
                synchronized (subtaskCounter) {
                    ++this.count;
                    if (this.count < 1) {
                        throw new IllegalStateException("Invalid task count: " + this.count);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void countDown() {
                Vector copiedWaitNodes = null;
                SubtaskCounter subtaskCounter = this;
                synchronized (subtaskCounter) {
                    --this.count;
                    if (this.count == 0) {
                        copiedWaitNodes = new Vector(this.taskWaitNodes);
                        this.taskWaitNodes.clear();
                    } else if (this.count < 0) {
                        throw new IllegalStateException("Invalid task count: " + this.count);
                    }
                }
                if (copiedWaitNodes != null) {
                    for (Callable callable : copiedWaitNodes) {
                        this.doCallback(callable);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void awaitAllTasks(Callable<Void> callback) {
                SubtaskCounter subtaskCounter = this;
                synchronized (subtaskCounter) {
                    if (this.count > 0) {
                        this.taskWaitNodes.add(callback);
                        return;
                    }
                }
                this.doCallback(callback);
            }

            private void doCallback(Callable<?> callback) {
                try {
                    callback.call();
                }
                catch (Throwable e) {
                    CombinedAsyncTask.this.lifecycle().failed(e);
                }
            }
        }

        private class ExceptionCatcher
        implements InvocationHandler {
            private Object target;

            public ExceptionCatcher(Object target) {
                Objects.requireNonNull(target);
                this.target = target;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke(this.target, args);
                }
                catch (Throwable e) {
                    Throwable exception = e;
                    if (e instanceof InvocationTargetException && (exception = e.getCause()) == null) {
                        exception = e;
                    }
                    CombinedAsyncTask.this.lifecycle().failed(exception);
                    return null;
                }
            }
        }
    }
}

