/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.combine;

import java.io.IOException;
import java.util.Objects;
import org.to2mbn.jmccc.mcdownloader.download.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.ResultProcessor;
import org.to2mbn.jmccc.mcdownloader.download.combine.AnyCombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.AppendedCombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.MultipleCombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.SingleCombinedDownloadTask;

public abstract class CombinedDownloadTask<T> {
    public static <T> CombinedDownloadTask<T> single(DownloadTask<T> task) {
        Objects.requireNonNull(task);
        return new SingleCombinedDownloadTask<T>(task);
    }

    public static CombinedDownloadTask<Void> multiple(DownloadTask<?> ... tasks) {
        Objects.requireNonNull(tasks);
        CombinedDownloadTask[] combinedTasks = new CombinedDownloadTask[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            combinedTasks[i] = CombinedDownloadTask.single(tasks[i]);
        }
        return CombinedDownloadTask.multiple(combinedTasks);
    }

    public static CombinedDownloadTask<Void> multiple(CombinedDownloadTask<?> ... tasks) {
        Objects.requireNonNull(tasks);
        return new MultipleCombinedDownloadTask(tasks);
    }

    @SafeVarargs
    public static <T> CombinedDownloadTask<T> any(DownloadTask<T> ... tasks) {
        Objects.requireNonNull(tasks);
        CombinedDownloadTask[] combinedTasks = new CombinedDownloadTask[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            combinedTasks[i] = CombinedDownloadTask.single(tasks[i]);
        }
        return CombinedDownloadTask.any(combinedTasks);
    }

    @SafeVarargs
    public static <T> CombinedDownloadTask<T> any(CombinedDownloadTask<T> ... tasks) {
        Objects.requireNonNull(tasks);
        return CombinedDownloadTask.any(new Class[]{IOException.class}, tasks);
    }

    @SafeVarargs
    public static <T> CombinedDownloadTask<T> any(Class<? extends Throwable>[] expectedExceptions, CombinedDownloadTask<T> ... tasks) {
        Objects.requireNonNull(tasks);
        Objects.requireNonNull(expectedExceptions);
        if (tasks.length == 0) {
            throw new IllegalArgumentException("The length of tasks cannot be zero");
        }
        return new AnyCombinedDownloadTask<T>(tasks, expectedExceptions);
    }

    public abstract void execute(CombinedDownloadContext<T> var1) throws Exception;

    public <R> CombinedDownloadTask<R> andThen(ResultProcessor<T, R> processor) {
        return new AppendedCombinedDownloadTask<T, R>(this, processor);
    }
}

