/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.to2mbn.jmccc.mcdownloader.download.DownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.DownloadCallbacks;
import org.to2mbn.jmccc.mcdownloader.download.DownloadSession;
import org.to2mbn.jmccc.mcdownloader.download.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.DownloaderService;
import org.to2mbn.jmccc.mcdownloader.download.NullDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CallbackAsyncFutureTask;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callbacks;

public class HttpAsyncDownloader
implements DownloaderService {
    private static final Log LOGGER = LogFactory.getLog(HttpAsyncDownloader.class);
    private static final int RUNNING = 0;
    private static final int SHUTDOWNING = 1;
    private static final int SHUTDOWNED = 2;
    private CloseableHttpAsyncClient httpClient;
    private Executor bootstrapPool;
    private volatile int status = 0;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Set<Future<?>> tasks = Collections.newSetFromMap(new ConcurrentHashMap());

    public HttpAsyncDownloader(HttpAsyncClientBuilder builder, Executor bootstrapPool) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(bootstrapPool);
        this.httpClient = builder.build();
        this.bootstrapPool = bootstrapPool;
        this.httpClient.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> download(DownloadTask<T> downloadTask, DownloadCallback<T> callback, int tries) {
        Objects.requireNonNull(downloadTask);
        if (tries < 1) {
            throw new IllegalArgumentException("tries < 1");
        }
        AsyncDownloadTask<T> task = new AsyncDownloadTask<T>(downloadTask, callback == null ? new NullDownloadCallback() : callback, tries);
        Callback statusCallback = Callbacks.whatever(new TaskInactiver(task));
        if (callback != null) {
            statusCallback = Callbacks.group(statusCallback, callback);
        }
        task.setCallback(statusCallback);
        Lock lock = this.rwlock.readLock();
        lock.lock();
        try {
            if (this.isShutdown()) {
                throw new RejectedExecutionException("The downloader has been shutdown.");
            }
            this.bootstrapPool.execute(task);
            this.tasks.add(task);
        }
        finally {
            lock.unlock();
        }
        return task;
    }

    @Override
    public void shutdown() {
        boolean isTasksEmpty;
        Lock lock = this.rwlock.writeLock();
        lock.lock();
        try {
            if (this.isShutdown()) {
                return;
            }
            this.status = 1;
            isTasksEmpty = this.tasks.isEmpty();
            if (isTasksEmpty) {
                this.status = 2;
            }
        }
        finally {
            lock.unlock();
        }
        if (isTasksEmpty) {
            this.completeShutdown();
        } else {
            for (Future<?> task : this.tasks) {
                task.cancel(true);
            }
        }
    }

    @Override
    public <T> Future<T> download(DownloadTask<T> task, DownloadCallback<T> callback) {
        return this.download(task, callback, 1);
    }

    @Override
    public boolean isShutdown() {
        return this.status != 0;
    }

    private void completeShutdown() {
        this.bootstrapPool = null;
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"an exception occurred during shutdown http client", (Throwable)e);
        }
        this.httpClient = null;
    }

    private class TaskInactiver
    implements Runnable {
        private final Future<?> task;

        public TaskInactiver(Future<?> task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Lock rlock = HttpAsyncDownloader.this.rwlock.readLock();
            rlock.lock();
            try {
                HttpAsyncDownloader.this.tasks.remove(this.task);
            }
            finally {
                rlock.unlock();
            }
            if (HttpAsyncDownloader.this.status == 1) {
                boolean doCleanup = false;
                Lock wlock = HttpAsyncDownloader.this.rwlock.writeLock();
                wlock.lock();
                try {
                    if (HttpAsyncDownloader.this.status == 1 && HttpAsyncDownloader.this.tasks.isEmpty()) {
                        HttpAsyncDownloader.this.status = 2;
                        doCleanup = true;
                    }
                }
                finally {
                    wlock.unlock();
                }
                if (doCleanup) {
                    HttpAsyncDownloader.this.completeShutdown();
                }
            }
        }
    }

    private class AsyncDownloadTask<T>
    extends CallbackAsyncFutureTask<T> {
        private final DownloadTask<T> task;
        private final DownloadCallback<T> callback;
        private final int maxTries;
        private volatile int currentTries;

        public AsyncDownloadTask(DownloadTask<T> task, DownloadCallback<T> callback, int maxTries) {
            Objects.requireNonNull(task);
            Objects.requireNonNull(callback);
            if (maxTries < 1) {
                throw new IllegalArgumentException(String.valueOf(maxTries));
            }
            this.task = task;
            this.callback = callback;
            this.maxTries = maxTries;
        }

        @Override
        protected void execute() throws Exception {
            this.download();
        }

        private void download() {
            if (Thread.interrupted() || this.isExceptional()) {
                this.lifecycle().cancelled();
                return;
            }
            CallbackAsyncFutureTask.FutureManager manager = this.createFutureManager();
            DownloadRetryHandler retryHandler = new DownloadRetryHandler();
            DownloadSessionHandler<T> handler = new DownloadSessionHandler<T>(this.task, DownloadCallbacks.group(DownloadCallbacks.fromCallback(manager), retryHandler));
            Future downloadFuture = HttpAsyncDownloader.this.httpClient.execute(HttpAsyncMethods.createGet((URI)this.task.getURI()), handler.consumer, handler.callback);
            manager.setFuture(downloadFuture);
        }

        private class DownloadRetryHandler
        implements DownloadCallback<T> {
            private DownloadRetryHandler() {
            }

            @Override
            public void done(T result) {
                AsyncDownloadTask.this.lifecycle().done(result);
            }

            @Override
            public void failed(Throwable e) {
                AsyncDownloadTask.this.currentTries++;
                if (e instanceof IOException && AsyncDownloadTask.this.currentTries < AsyncDownloadTask.this.maxTries) {
                    AsyncDownloadTask.this.callback.retry(e, AsyncDownloadTask.this.currentTries, AsyncDownloadTask.this.maxTries);
                    AsyncDownloadTask.this.download();
                } else {
                    AsyncDownloadTask.this.lifecycle().failed(e);
                }
            }

            @Override
            public void cancelled() {
                AsyncDownloadTask.this.lifecycle().cancelled();
            }

            @Override
            public void updateProgress(long done, long total) {
                AsyncDownloadTask.this.callback.updateProgress(done, total);
            }

            @Override
            public void retry(Throwable e, int current, int max) {
                throw new AssertionError((Object)"This method shouldn't be invoked.");
            }
        }
    }

    private static class DownloadSessionHandler<T> {
        private final DownloadTask<T> task;
        private final DownloadCallback<T> downloadCallback;
        private volatile DownloadSession<T> session;
        private volatile Throwable resultBuildingEx;
        public final HttpAsyncResponseConsumer<T> consumer;
        public final FutureCallback<T> callback;

        public DownloadSessionHandler(DownloadTask<T> task, DownloadCallback<T> downloadCallback) {
            Objects.requireNonNull(task);
            Objects.requireNonNull(downloadCallback);
            this.task = task;
            this.downloadCallback = downloadCallback;
            this.consumer = new DataConsumer();
            this.callback = new DownloadCallbackAdapter(downloadCallback);
        }

        private class DownloadCallbackAdapter
        implements FutureCallback<T> {
            private final Callback<T> adapted;

            public DownloadCallbackAdapter(Callback<T> adapted) {
                this.adapted = adapted;
            }

            public void completed(T result) {
                if (DownloadSessionHandler.this.resultBuildingEx == null) {
                    this.adapted.done(result);
                } else {
                    this.adapted.failed(DownloadSessionHandler.this.resultBuildingEx);
                }
            }

            public void failed(Exception ex) {
                block3: {
                    if (DownloadSessionHandler.this.session != null) {
                        try {
                            DownloadSessionHandler.this.session.failed();
                        }
                        catch (Throwable e) {
                            if (e == ex) break block3;
                            ex.addSuppressed(e);
                        }
                    }
                }
                this.adapted.failed(ex);
            }

            public void cancelled() {
                if (DownloadSessionHandler.this.session != null) {
                    try {
                        DownloadSessionHandler.this.session.failed();
                    }
                    catch (Throwable e) {
                        this.adapted.failed(e);
                        return;
                    }
                }
                this.adapted.cancelled();
            }
        }

        private class DataConsumer
        extends AsyncByteConsumer<T> {
            private volatile long contextLength = -1L;
            private volatile long received = 0L;

            private DataConsumer() {
            }

            protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
                if (DownloadSessionHandler.this.session == null) {
                    DownloadSessionHandler.this.session = DownloadSessionHandler.this.task.createSession();
                }
                this.received += (long)buf.remaining();
                DownloadSessionHandler.this.session.receiveData(buf);
                DownloadSessionHandler.this.downloadCallback.updateProgress(this.received, this.contextLength);
            }

            protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
                int statusCode;
                if (response.getStatusLine() != null && ((statusCode = response.getStatusLine().getStatusCode()) < 200 || statusCode > 299)) {
                    throw new IOException("Illegal http response code: " + statusCode);
                }
                if (DownloadSessionHandler.this.session == null) {
                    long contextLength;
                    HttpEntity httpEntity = response.getEntity();
                    if (httpEntity != null && (contextLength = httpEntity.getContentLength()) >= 0L) {
                        this.contextLength = contextLength;
                    }
                    DownloadSessionHandler.this.session = this.contextLength > 0L ? DownloadSessionHandler.this.task.createSession(this.contextLength) : DownloadSessionHandler.this.task.createSession();
                }
            }

            protected T buildResult(HttpContext context) throws Exception {
                Object result = null;
                try {
                    if (DownloadSessionHandler.this.session == null) {
                        throw new IllegalStateException("Download session is not active");
                    }
                    result = DownloadSessionHandler.this.session.completed();
                    DownloadSessionHandler.this.resultBuildingEx = null;
                }
                catch (Throwable e) {
                    DownloadSessionHandler.this.resultBuildingEx = e;
                }
                return result;
            }
        }
    }
}

