/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.to2mbn.jmccc.mcdownloader.IncrementallyDownloadTask;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloader;
import org.to2mbn.jmccc.mcdownloader.RemoteVersionList;
import org.to2mbn.jmccc.mcdownloader.download.DownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.DownloaderService;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloader;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloaderImpl;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.Version;

public class MinecraftDownloaderImpl
implements MinecraftDownloader {
    private DownloaderService downloader;
    private ExecutorService executor;
    private CombinedDownloader combinedDownloader;
    private MinecraftDownloadProvider downloadProvider;
    private int tries;
    private boolean checkLibrariesHash;
    private boolean checkAssetsHash;
    private volatile boolean shutdown = false;
    private ReadWriteLock shutdownLock = new ReentrantReadWriteLock();

    public MinecraftDownloaderImpl(DownloaderService downloader, ExecutorService executor, MinecraftDownloadProvider downloadProvider, int tries, boolean checkLibrariesHash, boolean checkAssetsHash) {
        this.downloader = downloader;
        this.executor = executor;
        this.downloadProvider = downloadProvider;
        this.tries = tries;
        this.checkLibrariesHash = checkLibrariesHash;
        this.checkAssetsHash = checkAssetsHash;
        this.combinedDownloader = new CombinedDownloaderImpl(executor, downloader, tries);
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            Lock lock = this.shutdownLock.writeLock();
            lock.lock();
            try {
                this.shutdown = true;
            }
            finally {
                lock.unlock();
            }
            this.combinedDownloader.shutdown();
            this.downloader.shutdown();
            this.executor.shutdown();
            this.combinedDownloader = null;
            this.downloader = null;
            this.executor = null;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public <T> Future<T> download(DownloadTask<T> task, DownloadCallback<T> callback) {
        return this.download(task, callback, this.tries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> download(DownloadTask<T> task, DownloadCallback<T> callback, int tries) {
        Lock lock = this.shutdownLock.readLock();
        lock.lock();
        try {
            this.checkShutdown();
            Future<T> future = this.downloader.download(task, callback, tries);
            return future;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T> Future<T> download(CombinedDownloadTask<T> task, CombinedDownloadCallback<T> callback) {
        return this.download(task, callback, this.tries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> download(CombinedDownloadTask<T> task, CombinedDownloadCallback<T> callback, int tries) {
        Lock lock = this.shutdownLock.readLock();
        lock.lock();
        try {
            this.checkShutdown();
            Future<T> future = this.combinedDownloader.download(task, callback, tries);
            return future;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Future<Version> downloadIncrementally(MinecraftDirectory dir, String version, CombinedDownloadCallback<Version> callback) {
        return this.download(new IncrementallyDownloadTask(this.downloadProvider, dir, version, this.checkLibrariesHash, this.checkAssetsHash), callback, this.tries);
    }

    @Override
    public Future<RemoteVersionList> fetchRemoteVersionList(CombinedDownloadCallback<RemoteVersionList> callback) {
        return this.download(this.downloadProvider.versionList(), callback, this.tries);
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new RejectedExecutionException("already shutdown");
        }
    }
}

