/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.to2mbn.jmccc.mcdownloader.AppendedDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloader;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloaderImpl;
import org.to2mbn.jmccc.mcdownloader.download.DownloaderService;
import org.to2mbn.jmccc.mcdownloader.download.HttpAsyncDownloader;
import org.to2mbn.jmccc.mcdownloader.download.JdkHttpDownloader;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Shutdownable;
import org.to2mbn.jmccc.mcdownloader.provider.ExtendedDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.InfoDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.MojangDownloadProvider;

public class MinecraftDownloaderBuilder {
    private static final int BIO_MAX_CONNECTIONS = 20;
    private int maxConnections;
    private int maxConnectionsPerRouter;
    private MinecraftDownloadProvider baseProvider = new MojangDownloadProvider();
    private List<MinecraftDownloadProvider> appendProviders = new ArrayList<MinecraftDownloadProvider>();
    private int poolMaxThreads = Runtime.getRuntime().availableProcessors();
    private long poolThreadLivingTime = 10000L;
    private int defaultTries = 3;
    private int connectTimeout = 10000;
    private int soTimeout = 30000;
    private boolean disableApacheHttpAsyncClient = false;
    private boolean useVersionDownloadInfo = true;
    private Proxy proxy = Proxy.NO_PROXY;
    private boolean checkLibrariesHash = true;
    private boolean checkAssetsHash = true;
    private boolean disableBioConnectionsLimit = false;

    public static MinecraftDownloaderBuilder create() {
        return new MinecraftDownloaderBuilder();
    }

    protected MinecraftDownloaderBuilder() {
    }

    public MinecraftDownloaderBuilder setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public MinecraftDownloaderBuilder setMaxConnectionsPerRouter(int maxConnectionsPerRouter) {
        this.maxConnectionsPerRouter = maxConnectionsPerRouter;
        return this;
    }

    public MinecraftDownloaderBuilder setBaseProvider(MinecraftDownloadProvider baseprovider) {
        Objects.requireNonNull(baseprovider);
        this.baseProvider = baseprovider;
        return this;
    }

    public MinecraftDownloaderBuilder setPoolMaxThreads(int poolMaxThreads) {
        this.poolMaxThreads = poolMaxThreads;
        return this;
    }

    public MinecraftDownloaderBuilder setPoolThreadLivingTime(long poolThreadLivingTime) {
        this.poolThreadLivingTime = poolThreadLivingTime;
        return this;
    }

    public MinecraftDownloaderBuilder setDefaultTries(int defaultTries) {
        this.defaultTries = defaultTries;
        return this;
    }

    public MinecraftDownloaderBuilder setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public MinecraftDownloaderBuilder setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public MinecraftDownloaderBuilder appendProvider(MinecraftDownloadProvider appendProvider) {
        Objects.requireNonNull(appendProvider);
        this.appendProviders.add(appendProvider);
        return this;
    }

    public MinecraftDownloaderBuilder disableApacheHttpAsyncClient() {
        this.disableApacheHttpAsyncClient = true;
        return this;
    }

    public MinecraftDownloaderBuilder disableBioConnectionsLimit() {
        this.disableBioConnectionsLimit = true;
        return this;
    }

    public MinecraftDownloaderBuilder setUseVersionDownloadInfo(boolean useVersionDownloadInfo) {
        this.useVersionDownloadInfo = useVersionDownloadInfo;
        return this;
    }

    public MinecraftDownloaderBuilder setProxy(Proxy proxy) {
        Objects.requireNonNull(proxy);
        this.proxy = proxy;
        return this;
    }

    public MinecraftDownloaderBuilder setCheckLibrariesHash(boolean checkLibrariesHash) {
        this.checkLibrariesHash = checkLibrariesHash;
        return this;
    }

    public MinecraftDownloaderBuilder setCheckAssetsHash(boolean checkAssetsHash) {
        this.checkAssetsHash = checkAssetsHash;
        return this;
    }

    public MinecraftDownloader build() {
        ExecutorService executor = null;
        Shutdownable downloader = null;
        Shutdownable mcdownloader = null;
        try {
            MinecraftDownloadProvider provider = this.resolveProvider();
            executor = new ThreadPoolExecutor(this.poolMaxThreads, this.poolMaxThreads, this.poolThreadLivingTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            if (!this.disableApacheHttpAsyncClient && MinecraftDownloaderBuilder.isApacheHttpAsyncClientAvailable()) {
                HttpHost proxyHost = this.resolveProxy();
                HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create().setMaxConnTotal(this.maxConnections).setMaxConnPerRoute(this.maxConnectionsPerRouter == 0 ? this.maxConnections : this.maxConnectionsPerRouter).setProxy(proxyHost).setDefaultIOReactorConfig(IOReactorConfig.custom().setConnectTimeout(this.connectTimeout).setSoTimeout(this.soTimeout).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.soTimeout).setProxy(proxyHost).build());
                downloader = new HttpAsyncDownloader(httpClientBuilder, executor);
            } else {
                int conns;
                int n = conns = this.maxConnections > 0 ? this.maxConnections : Runtime.getRuntime().availableProcessors() * 2;
                if (!this.disableBioConnectionsLimit) {
                    conns = Math.min(conns, 20);
                }
                downloader = new JdkHttpDownloader(conns, this.connectTimeout, this.soTimeout, this.poolThreadLivingTime, this.proxy);
            }
            mcdownloader = new MinecraftDownloaderImpl((DownloaderService)downloader, executor, provider, this.defaultTries, this.checkLibrariesHash, this.checkAssetsHash);
        }
        catch (Throwable e) {
            if (executor != null) {
                try {
                    executor.shutdown();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            if (downloader != null) {
                try {
                    downloader.shutdown();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            if (mcdownloader != null) {
                try {
                    mcdownloader.shutdown();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
        return mcdownloader;
    }

    private HttpHost resolveProxy() {
        SocketAddress socketAddress;
        if (this.proxy.type() == Proxy.Type.DIRECT) {
            return null;
        }
        if (this.proxy.type() == Proxy.Type.HTTP && (socketAddress = this.proxy.address()) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return new HttpHost(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        throw new IllegalArgumentException("Proxy '" + this.proxy + "' is not supported");
    }

    private static boolean isApacheHttpAsyncClientAvailable() {
        try {
            Class.forName("org.apache.http.impl.nio.client.HttpAsyncClientBuilder");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private MinecraftDownloadProvider resolveProvider() {
        MinecraftDownloadProvider right = this.baseProvider;
        for (MinecraftDownloadProvider left : this.appendProviders) {
            if (left instanceof ExtendedDownloadProvider) {
                ((ExtendedDownloadProvider)left).setUpstreamProvider(this.resolveBeginningProvider(right));
            }
            right = new AppendedDownloadProvider(left, right);
        }
        right = this.resolveBeginningProvider(right);
        return right;
    }

    private MinecraftDownloadProvider resolveBeginningProvider(MinecraftDownloadProvider right) {
        for (MinecraftDownloadProvider left : this.createBeginningProviders()) {
            if (left instanceof ExtendedDownloadProvider) {
                ((ExtendedDownloadProvider)left).setUpstreamProvider(right);
            }
            right = new AppendedDownloadProvider(left, right);
        }
        return right;
    }

    protected List<MinecraftDownloadProvider> createBeginningProviders() {
        ArrayList<MinecraftDownloadProvider> providers = new ArrayList<MinecraftDownloadProvider>();
        if (this.useVersionDownloadInfo) {
            providers.add(new InfoDownloadProvider());
        }
        return providers;
    }
}

