/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.to2mbn.jmccc.mcdownloader.download.combine.AbstractCombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.ChecksumUtils;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.DownloadInfo;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.Versions;

public class IncrementallyDownloadTask
extends CombinedDownloadTask<Version> {
    private MinecraftDirectory mcdir;
    private String version;
    private MinecraftDownloadProvider downloadProvider;
    private boolean checkLibrariesHash;
    private boolean checkAssetsHash;
    private Set<String> handledVersions = Collections.newSetFromMap(new ConcurrentHashMap());
    private String resolvedVersion;

    public IncrementallyDownloadTask(MinecraftDownloadProvider downloadProvider, MinecraftDirectory mcdir, String version, boolean checkLibrariesHash, boolean checkAssetsHash) {
        Objects.requireNonNull(mcdir);
        Objects.requireNonNull(version);
        Objects.requireNonNull(downloadProvider);
        this.mcdir = mcdir;
        this.version = version;
        this.downloadProvider = downloadProvider;
        this.checkLibrariesHash = checkLibrariesHash;
        this.checkAssetsHash = checkAssetsHash;
    }

    @Override
    public void execute(final CombinedDownloadContext<Version> context) throws Exception {
        this.handledVersions.clear();
        this.resolvedVersion = null;
        this.handleVersionJson(this.version, context, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (IncrementallyDownloadTask.this.resolvedVersion == null) {
                    IncrementallyDownloadTask.this.resolvedVersion = IncrementallyDownloadTask.this.version;
                }
                final Version versionModel = Versions.resolveVersion((MinecraftDirectory)IncrementallyDownloadTask.this.mcdir, (String)IncrementallyDownloadTask.this.resolvedVersion);
                if (IncrementallyDownloadTask.this.mcdir.getAssetIndex(versionModel).exists()) {
                    IncrementallyDownloadTask.this.downloadAssets(context, Versions.resolveAssets((MinecraftDirectory)IncrementallyDownloadTask.this.mcdir, (Version)versionModel));
                } else {
                    context.submit(IncrementallyDownloadTask.this.downloadProvider.assetsIndex(IncrementallyDownloadTask.this.mcdir, versionModel), new AbstractCombinedDownloadCallback<Set<Asset>>(){

                        @Override
                        public void done(final Set<Asset> result) {
                            try {
                                context.submit(new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        IncrementallyDownloadTask.this.downloadAssets(context, result);
                                        return null;
                                    }
                                }, null, true);
                            }
                            catch (InterruptedException e) {
                                context.cancelled();
                            }
                        }
                    }, true);
                }
                if (!IncrementallyDownloadTask.this.mcdir.getVersionJar(versionModel).exists()) {
                    context.submit(IncrementallyDownloadTask.this.downloadProvider.gameJar(IncrementallyDownloadTask.this.mcdir, versionModel), null, true);
                }
                IncrementallyDownloadTask.this.downloadLibraries(context, versionModel);
                context.awaitAllTasks(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        context.done(versionModel);
                        return null;
                    }
                });
                return null;
            }
        });
    }

    private void handleVersionJson(final String currentVersion, final CombinedDownloadContext<Version> context, final Callable<Void> callback) throws Exception {
        if (this.mcdir.getVersionJson(currentVersion).exists()) {
            JSONObject versionjson = this.readJson(this.mcdir.getVersionJson(currentVersion));
            String inheritsFrom = versionjson.optString("inheritsFrom", null);
            this.handledVersions.add(currentVersion);
            if (inheritsFrom == null) {
                callback.call();
            } else {
                if (this.handledVersions.contains(inheritsFrom)) {
                    throw new IllegalStateException("loop inherits from: " + currentVersion + " to " + inheritsFrom);
                }
                this.handleVersionJson(inheritsFrom, context, callback);
            }
        } else {
            context.submit(this.downloadProvider.gameVersionJson(this.mcdir, currentVersion), new AbstractCombinedDownloadCallback<String>(){

                @Override
                public void done(final String currentResolvedVersion) {
                    try {
                        context.submit(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                if (IncrementallyDownloadTask.this.version.equals(currentVersion)) {
                                    IncrementallyDownloadTask.this.resolvedVersion = currentResolvedVersion;
                                }
                                IncrementallyDownloadTask.this.handleVersionJson(currentResolvedVersion, context, callback);
                                return null;
                            }
                        }, null, true);
                    }
                    catch (InterruptedException e) {
                        context.cancelled();
                    }
                }
            }, true);
        }
    }

    private void downloadAssets(final CombinedDownloadContext<Version> context, Set<Asset> assets) throws InterruptedException {
        if (assets == null) {
            return;
        }
        HashMap<String, Asset> hashMapping = new HashMap<String, Asset>();
        for (final Asset asset : assets) {
            hashMapping.put(asset.getHash(), asset);
        }
        if (this.checkAssetsHash) {
            for (final Asset asset : hashMapping.values()) {
                context.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (!asset.isValid(IncrementallyDownloadTask.this.mcdir)) {
                            context.submit(IncrementallyDownloadTask.this.downloadProvider.asset(IncrementallyDownloadTask.this.mcdir, asset), null, false);
                        }
                        return null;
                    }
                }, null, false);
            }
        } else {
            for (final Asset asset : hashMapping.values()) {
                if (this.mcdir.getAsset(asset).isFile()) continue;
                context.submit(this.downloadProvider.asset(this.mcdir, asset), null, false);
            }
        }
    }

    private void downloadLibraries(final CombinedDownloadContext<Version> context, Version version) throws InterruptedException {
        if (this.checkLibrariesHash) {
            for (final Library library : version.getLibraries()) {
                context.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (IncrementallyDownloadTask.this.needDownload(IncrementallyDownloadTask.this.mcdir.getLibrary(library), (DownloadInfo)library.getDownloadInfo())) {
                            context.submit(IncrementallyDownloadTask.this.downloadProvider.library(IncrementallyDownloadTask.this.mcdir, library), null, true);
                        }
                        return null;
                    }
                }, null, true);
            }
        } else {
            for (Library library : version.getMissingLibraries(this.mcdir)) {
                context.submit(this.downloadProvider.library(this.mcdir, library), null, true);
            }
        }
    }

    private boolean needDownload(File target, DownloadInfo info) throws NoSuchAlgorithmException, IOException {
        if (info == null) {
            return !target.isFile();
        }
        return !ChecksumUtils.verify((File)target, (String)info.getChecksum(), (String)"SHA-1", (long)info.getSize());
    }

    private JSONObject readJson(File file) throws IOException, JSONException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), "UTF-8");){
            JSONObject jSONObject = new JSONObject(new JSONTokener((Reader)reader));
            return jSONObject;
        }
    }
}

