/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.test;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.dev.common.DateUtils;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.accounts.actions.CreateAccountAction;
import org.tiogasolutions.push.kernel.actions.CreateDomainAction;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.kernel.system.Session;
import org.tiogasolutions.push.pub.SmtpEmailPush;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.UserAgent;

@Component
public class TestFixture {
    public static final ZoneId westCoastTimeZone = DateUtils.PDT;
    @Autowired
    private DomainStore domainStore;
    @Autowired
    private AccountStore accountStore;
    @Autowired
    private PushRequestStore pushRequestStore;

    public UserAgent createUserAgent() {
        return new UserAgent("agent-type", "agent-name", "agent-version", "agent-language", "agent-lang-tag", "os-type", "os-name", "os=produceer", "osproducer-url", "os-version-name", "os-version-number", "linux-distro");
    }

    public Account createAccount() {
        CreateAccountAction createAccount = new CreateAccountAction(westCoastTimeZone, "test@jacobparr.com", "Unit", "Test", "testing123", "testing123");
        Account account = new Account(createAccount);
        this.accountStore.create((Object)account);
        return account;
    }

    public DomainProfileEntity createDomain(Account account) {
        CreateDomainAction createClient = new CreateDomainAction(account, "some-key", "some-password");
        DomainProfileEntity domain = account.add(createClient);
        this.domainStore.create((Object)domain);
        return domain;
    }

    public List<PushRequest> createPushRequests_Emails(DomainProfileEntity domain) throws Exception {
        ArrayList<PushRequest> requests = new ArrayList<PushRequest>();
        SmtpEmailPush push = SmtpEmailPush.newPush((String)"to@example.com", (String)"from@example.com", (String)"This is the subject", (String)"<html><body><h1>Hello World</h1></body></html>", null, (String[])new String[0]);
        PushRequest pushRequest = new PushRequest(3, domain, (Push)push);
        requests.add(pushRequest);
        this.pushRequestStore.create((Object)pushRequest);
        return requests;
    }

    public List<PushRequest> createPushRequests(DomainProfileEntity domain) throws Exception {
        TreeSet<PushRequest> requests = new TreeSet<PushRequest>();
        requests.addAll(this.createPushRequests_Emails(domain));
        return new ArrayList<PushRequest>(requests);
    }

    public Session createSession() {
        return new Session(0L, "test@example.com");
    }
}

