/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.tiogasolutions.apis.bitly.BitlyApis;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.push.jackson.PushObjectMapper;
import org.tiogasolutions.push.kernel.config.CouchServersConfig;
import org.tiogasolutions.push.kernel.system.SessionStore;

@Profile(value={"test"})
@Configuration
public class SpringTestConfig {
    @Bean
    public PushObjectMapper cpObjectMapper() {
        return new PushObjectMapper();
    }

    @Bean
    public TiogaJacksonTranslator tiogaJacksonTranslator(PushObjectMapper objectMapper) {
        return new TiogaJacksonTranslator((ObjectMapper)objectMapper);
    }

    @Bean
    public SessionStore sessionStore() {
        return new SessionStore(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS));
    }

    @Bean
    public BitlyApis bitlyApis(TiogaJacksonTranslator translator) {
        return new BitlyApis((JsonTranslator)translator, "9f5ed9c08c695b4a017bfb432eea58876a5d40cb");
    }

    @Bean
    public CouchServersConfig couchServersConfig() {
        CouchServersConfig config = new CouchServersConfig();
        config.setMasterUrl("http://localhost:5984");
        config.setMasterUserName("test-user");
        config.setMasterPassword("test-user");
        config.setMasterDatabaseName("test-push");
        config.setDomainUrl("http://localhost:5984");
        config.setDomainUserName("test-user");
        config.setDomainPassword("test-user");
        config.setDomainDatabasePrefix("test-push-");
        return config;
    }
}

