/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.test;

import java.net.URI;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.request.CouchFeature;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.dev.common.DateUtils;
import org.tiogasolutions.lib.couchace.DefaultCouchServer;
import org.tiogasolutions.push.common.accounts.Account;
import org.tiogasolutions.push.common.accounts.AccountStore;
import org.tiogasolutions.push.common.accounts.DomainStore;
import org.tiogasolutions.push.common.accounts.actions.CreateAccountAction;
import org.tiogasolutions.push.common.actions.CreateDomainAction;
import org.tiogasolutions.push.common.clients.Domain;
import org.tiogasolutions.push.common.plugins.PluginContext;
import org.tiogasolutions.push.common.plugins.PushProcessor;
import org.tiogasolutions.push.common.requests.PushRequest;
import org.tiogasolutions.push.common.requests.PushRequestStore;
import org.tiogasolutions.push.common.system.AppContext;
import org.tiogasolutions.push.common.system.CpCouchServer;
import org.tiogasolutions.push.common.system.DomainDatabaseConfig;
import org.tiogasolutions.push.common.system.Session;
import org.tiogasolutions.push.jackson.CpObjectMapper;
import org.tiogasolutions.push.pub.LqNotificationPush;
import org.tiogasolutions.push.pub.SmtpEmailPush;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.UserAgent;

public class TestFactory {
    private static TestFactory SINGLETON;
    public static final ZoneId westCoastTimeZone;
    private final DomainDatabaseConfig databaseConfig;
    private final CpCouchServer couchServer;
    private final CpObjectMapper objectMapper = new CpObjectMapper();
    private final AccountStore accountStore;
    private final DomainStore domainStore;
    private final PushRequestStore pushRequestStore;

    public static TestFactory get() throws Exception {
        if (SINGLETON == null) {
            SINGLETON = new TestFactory();
        }
        return SINGLETON;
    }

    public TestFactory() throws Exception {
        DefaultCouchServer server = new DefaultCouchServer();
        String sysDatabase = "test-push";
        String usrDatabase = "test-push-domain";
        for (String dbName : Arrays.asList(sysDatabase, usrDatabase)) {
            CouchDatabase database = server.database(dbName, CouchFeatureSet.builder().add(CouchFeature.ALLOW_DB_DELETE, (Object)true).build());
            if (!database.exists()) continue;
            database.deleteDatabase();
        }
        this.couchServer = new CpCouchServer();
        this.databaseConfig = new DomainDatabaseConfig(this.couchServer, usrDatabase);
        this.accountStore = new AccountStore(this.couchServer, sysDatabase);
        this.domainStore = new DomainStore(this.couchServer, sysDatabase);
        this.pushRequestStore = new PushRequestStore(this.databaseConfig);
    }

    public DomainDatabaseConfig getDatabaseConfig() {
        return this.databaseConfig;
    }

    public CpObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public AccountStore getAccountStore() {
        return this.accountStore;
    }

    public PushRequestStore getPushRequestStore() {
        return this.pushRequestStore;
    }

    public DomainStore getDomainStore() {
        return this.domainStore;
    }

    public UserAgent createUserAgent() {
        return new UserAgent("agent-type", "agent-name", "agent-version", "agent-language", "agent-lang-tag", "os-type", "os-name", "os=produceer", "osproducer-url", "os-version-name", "os-version-number", "linux-distro");
    }

    public Account createAccount() {
        CreateAccountAction createAccount = new CreateAccountAction(westCoastTimeZone, "test@jacobparr.com", "Unit", "Test", "testing123", "testing123");
        return new Account(createAccount);
    }

    public Domain createDomain(Account account) {
        CreateDomainAction createClient = new CreateDomainAction(account, "some-key", "some-password");
        Domain domain = account.add(createClient);
        this.domainStore.create((Object)domain);
        return domain;
    }

    public List<PushRequest> createPushRequests_Notifications(Domain domain) throws Exception {
        ArrayList<PushRequest> requests = new ArrayList<PushRequest>();
        LqNotificationPush push = LqNotificationPush.newPush((String)"Something bad happened", null, (String)"test:true", (String)"boy:girl", (String[])new String[]{"color:red"});
        PushRequest pushRequest = new PushRequest(2, domain, (Push)push);
        this.pushRequestStore.create((Object)pushRequest);
        requests.add(pushRequest);
        return requests;
    }

    public List<PushRequest> createPushRequests_Emails(Domain domain) throws Exception {
        ArrayList<PushRequest> requests = new ArrayList<PushRequest>();
        SmtpEmailPush push = SmtpEmailPush.newPush((String)"to@example.com", (String)"from@example.com", (String)"This is the subject", (String)"<html><body><h1>Hello World</h1></body></html>", null, (String[])new String[0]);
        PushRequest pushRequest = new PushRequest(2, domain, (Push)push);
        this.pushRequestStore.create((Object)pushRequest);
        requests.add(pushRequest);
        return requests;
    }

    public List<PushRequest> createPushRequests(Domain domain) throws Exception {
        TreeSet<PushRequest> requests = new TreeSet<PushRequest>();
        requests.addAll(this.createPushRequests_Emails(domain));
        requests.addAll(this.createPushRequests_Notifications(domain));
        return new ArrayList<PushRequest>(requests);
    }

    public PluginContext pluginContext(final TestFactory testFactory) {
        return new PluginContext(){

            public PushRequestStore getPushRequestStore() {
                return testFactory.getPushRequestStore();
            }

            public DomainStore getDomainStore() {
                return testFactory.getDomainStore();
            }

            public CpObjectMapper getObjectMapper() {
                return testFactory.getObjectMapper();
            }

            public DomainDatabaseConfig getDatabaseConfig() {
                return testFactory.getDatabaseConfig();
            }

            public URI getBaseURI() {
                return URI.create("http://localhost:8080/push-server");
            }

            public PushProcessor getPushProcessor() {
                return null;
            }

            public AppContext getAppContext() {
                return null;
            }

            public void setLastMessage(String message) {
            }
        };
    }

    public Session createSession() {
        return new Session(0L, "test@example.com");
    }

    static {
        westCoastTimeZone = DateUtils.PDT;
    }
}

