/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.xmpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.apis.bitly.BitlyApis;
import org.tiogasolutions.dev.common.Formats;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.push.jackson.PushObjectMapper;
import org.tiogasolutions.push.kernel.KernelUtils;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionContext;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.PluginSupport;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.plugins.xmpp.UpdateXmppConfigAction;
import org.tiogasolutions.push.plugins.xmpp.XmppConfig;
import org.tiogasolutions.push.plugins.xmpp.XmppConfigStore;
import org.tiogasolutions.push.plugins.xmpp.XmppDelegate;
import org.tiogasolutions.push.pub.XmppPush;
import org.tiogasolutions.push.pub.common.Push;

@Component
public class XmppPlugin
extends PluginSupport {
    private final BitlyApis bitlyApis;

    @Autowired
    public XmppPlugin(ExecutionManager executionManager, PushObjectMapper objectMapper, PushRequestStore pushRequestStore, BitlyApis bitlyApis) {
        super(XmppPush.PUSH_TYPE, executionManager, objectMapper, pushRequestStore);
        this.bitlyApis = bitlyApis;
    }

    public XmppConfigStore getConfigStore(ExecutionManager executionManager) {
        return new XmppConfigStore(executionManager);
    }

    public XmppConfig getConfig(DomainProfileEntity domainProfile) {
        String docId = XmppConfigStore.toDocumentId(domainProfile);
        return (XmppConfig)this.getConfigStore(this.executionManager).getByDocumentId(docId);
    }

    public XmppDelegate newDelegate(DomainProfileEntity domainProfile, PushRequest pushRequest, Push push) {
        XmppConfig config = this.getConfig(domainProfile);
        return new XmppDelegate(this.executionManager.context(), this.objectMapper, this.pushRequestStore, this.bitlyApis, pushRequest, (XmppPush)push, config);
    }

    public void deleteConfig(DomainProfileEntity domainProfile) {
        XmppConfig config = this.getConfig(domainProfile);
        if (config != null) {
            this.getConfigStore(this.executionManager).delete(config);
            this.executionManager.context().setLastMessage("XMPP configuration deleted.");
        } else {
            this.executionManager.context().setLastMessage("XMPP configuration doesn't exist.");
        }
    }

    public void updateConfig(DomainProfileEntity domainProfile, MultivaluedMap<String, String> formParams) {
        UpdateXmppConfigAction action = new UpdateXmppConfigAction(domainProfile, formParams);
        XmppConfig xmppConfig = this.getConfig(domainProfile);
        if (xmppConfig == null) {
            xmppConfig = new XmppConfig();
        }
        xmppConfig.apply(action);
        this.getConfigStore(this.executionManager).update(xmppConfig);
        this.executionManager.context().setLastMessage("XMPP configuration updated.");
    }

    public void test(DomainProfileEntity domainProfile) throws Exception {
        XmppConfig config = this.getConfig(domainProfile);
        if (config == null) {
            String msg = "The XMPP config has not been specified.";
            this.executionManager.context().setLastMessage(msg);
            return;
        }
        String recipient = config.getTestAddress();
        if (StringUtils.isBlank((Object)recipient)) {
            String msg = "Test message cannot be sent with out specifying the test address.";
            this.executionManager.context().setLastMessage(msg);
            return;
        }
        String override = config.getRecipientOverride();
        if (StringUtils.isNotBlank((Object)override)) {
            recipient = override;
        }
        String when = Formats.defaultStamp((Object)new Date());
        XmppPush push = XmppPush.newPush((String)recipient, (String)String.format("XMPP test message from Cosmic Push sent at %s.", when), null, (String[])new String[]{"xmpp-test:true"});
        PushRequest pushRequest = new PushRequest(2, domainProfile, (Push)push);
        this.pushRequestStore.create((Object)pushRequest);
        if (new XmppDelegate(this.executionManager.context(), this.objectMapper, this.pushRequestStore, this.bitlyApis, pushRequest, push, config).execute(false)) {
            String msg = String.format("Test message sent from %s to %s:\n%s", config.getUsername(), recipient, push.getMessage());
            this.executionManager.context().setLastMessage(msg);
        }
    }

    public String getAdminUi(DomainProfileEntity domainProfile) throws IOException {
        ExecutionContext context = this.executionManager.context();
        String contextRoot = KernelUtils.getContextRoot((UriInfo)context.getUriInfo());
        XmppConfig config = this.getConfig(domainProfile);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/org/tiogasolutions/push/plugins/xmpp/admin.html");
        String content = IoUtils.toString((InputStream)stream);
        content = content.replace("${legend-class}", StringUtils.nullToString((Object)(config == null ? "no-config" : "")));
        content = content.replace("${push-type}", StringUtils.nullToString((Object)this.getPushType().getCode()));
        content = content.replace("${plugin-name}", StringUtils.nullToString((Object)this.getPluginName()));
        content = content.replace("${domain-key}", StringUtils.nullToString((Object)domainProfile.getDomainKey()));
        content = content.replace("${context-root}", contextRoot);
        content = content.replace("${config-user-name}", StringUtils.nullToString((Object)(config == null ? null : config.getUsername())));
        content = content.replace("${config-password}", StringUtils.nullToString((Object)(config == null ? null : config.getPassword())));
        content = content.replace("${config-host}", StringUtils.nullToString((Object)(config == null ? null : config.getHost())));
        content = content.replace("${config-port}", StringUtils.nullToString((Object)(config == null ? null : config.getPort())));
        content = content.replace("${config-service-name}", StringUtils.nullToString((Object)(config == null ? null : config.getServiceName())));
        content = content.replace("${config-test-address}", StringUtils.nullToString((Object)(config == null ? null : config.getTestAddress())));
        if ((content = content.replace("${config-recipient-override}", StringUtils.nullToString((Object)(config == null ? null : config.getRecipientOverride())))).contains("${")) {
            String msg = "The XMPP admin UI still contains un-parsed elements.";
            throw new IllegalStateException(msg);
        }
        return content;
    }
}

