/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.xmpp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.tiogasolutions.apis.bitly.BitlyApis;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.jackson.PushObjectMapper;
import org.tiogasolutions.push.kernel.AbstractDelegate;
import org.tiogasolutions.push.kernel.execution.ExecutionContext;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.plugins.xmpp.XmppConfig;
import org.tiogasolutions.push.pub.XmppPush;
import org.tiogasolutions.push.pub.common.RequestStatus;

public class XmppDelegate
extends AbstractDelegate {
    private static final Log log = LogFactory.getLog(XmppDelegate.class);
    private final XmppPush push;
    private final XmppConfig config;
    private final BitlyApis bitlyApis;

    public XmppDelegate(ExecutionContext executionContext, PushObjectMapper objectMapper, PushRequestStore pushRequestStore, BitlyApis bitlyApis, PushRequest pushRequest, XmppPush push, XmppConfig config) {
        super(executionContext, objectMapper, pushRequestStore, pushRequest);
        this.config = (XmppConfig)ExceptionUtils.assertNotNull((Object)config, (String)"config");
        this.push = (XmppPush)ExceptionUtils.assertNotNull((Object)push, (String)"push");
        this.bitlyApis = bitlyApis;
    }

    public synchronized RequestStatus processRequest() throws Exception {
        String apiMessage = this.sendMessage();
        return this.pushRequest.processed(apiMessage);
    }

    public String sendMessage() throws Exception {
        String message = this.push.getMessage();
        message = this.bitlyApis.parseAndShorten(message);
        if (StringUtils.isNotBlank((Object)this.config.getRecipientOverride())) {
            this.sendTo(this.config.getRecipientOverride(), message);
            return String.format("Request sent to recipient override, %s.", this.config.getRecipientOverride());
        }
        this.sendTo(this.push.getRecipient(), message);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendTo(String recipient, String message) throws Exception {
        log.info((Object)String.format("%s: %s", recipient, message));
        XMPPTCPConnection connection = null;
        try {
            XMPPTCPConnectionConfiguration.Builder builder = XMPPTCPConnectionConfiguration.builder();
            builder.setUsernameAndPassword((CharSequence)this.config.getUsername(), this.config.getPassword());
            builder.setHost(this.config.getHost());
            builder.setPort(this.config.getPortInt());
            builder.setServiceName(this.config.getServiceName());
            connection = new XMPPTCPConnection(builder.build());
            connection.setPacketReplyTimeout(30000L);
            connection.connect();
            connection.login();
            connection.sendStanza((Stanza)new Presence(Presence.Type.available));
            Message jabberMessage = new Message(recipient, Message.Type.chat);
            jabberMessage.setBody(message);
            connection.sendStanza((Stanza)jabberMessage);
            this.disconnect(connection);
        }
        catch (Throwable throwable) {
            this.disconnect(connection);
            throw throwable;
        }
    }

    private void disconnect(XMPPTCPConnection connection) {
        try {
            if (connection != null && connection.isConnected()) {
                connection.disconnect(new Presence(Presence.Type.unavailable));
            }
        }
        catch (SmackException.NotConnectedException notConnectedException) {
            // empty catch block
        }
    }
}

