/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.xmpp;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.push.kernel.plugins.PluginConfig;
import org.tiogasolutions.push.plugins.xmpp.UpdateXmppConfigAction;
import org.tiogasolutions.push.plugins.xmpp.XmppConfigStore;
import org.tiogasolutions.push.pub.internal.RequestErrors;

@CouchEntity(value="xmpp-config")
public class XmppConfig
implements PluginConfig,
Serializable {
    private String configId;
    private String revision;
    private String domainId;
    private String username;
    private String password;
    private String recipientOverride;
    private String testAddress;
    private String host;
    private String port;
    private String serviceName;

    public XmppConfig() {
    }

    @JsonCreator
    public XmppConfig(@JacksonInject(value="configId") String configId, @JacksonInject(value="revision") String revision, @JsonProperty(value="domainId") String domainId, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="host") String host, @JsonProperty(value="port") String port, @JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="recipientOverride") String recipientOverride, @JsonProperty(value="testAddress") String testAddress) {
        this.configId = configId;
        this.revision = revision;
        this.domainId = domainId;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.serviceName = serviceName;
        this.recipientOverride = recipientOverride;
        this.testAddress = testAddress;
    }

    public XmppConfig apply(UpdateXmppConfigAction action) {
        action.validate(new RequestErrors()).assertNoErrors();
        if (this.domainId != null && EqualsUtils.objectsNotEqual((Object)this.domainId, (Object)action.getDomain().getDomainId())) {
            String msg = "The specified push and this class are not for the same domain.";
            throw new IllegalArgumentException(msg);
        }
        this.domainId = action.getDomain().getDomainId();
        this.configId = XmppConfigStore.toDocumentId(action.getDomain());
        this.username = action.getUsername();
        this.password = action.getPassword();
        this.host = action.getHost();
        this.port = action.getPort();
        this.serviceName = action.getServiceName();
        this.recipientOverride = action.getRecipientOverride();
        this.testAddress = action.getTestAddress();
        return this;
    }

    @CouchId
    public String getConfigId() {
        return this.configId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRecipientOverride() {
        return this.recipientOverride;
    }

    public String getTestAddress() {
        return this.testAddress;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortInt() {
        return this.port == null ? 0 : Integer.valueOf(this.port);
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

