/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.xmpp;

import javax.ws.rs.core.MultivaluedMap;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidatableAction;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class UpdateXmppConfigAction
implements ValidatableAction {
    private final DomainProfileEntity domain;
    private final String username;
    private final String password;
    private final String recipientOverride;
    private String testAddress;
    private String host;
    private String port;
    private String serviceName;

    public UpdateXmppConfigAction(DomainProfileEntity domain, MultivaluedMap<String, String> formParams) {
        this.domain = domain;
        this.username = (String)formParams.getFirst((Object)"username");
        this.password = (String)formParams.getFirst((Object)"password");
        this.host = (String)formParams.getFirst((Object)"host");
        this.port = (String)formParams.getFirst((Object)"port");
        this.serviceName = (String)formParams.getFirst((Object)"serviceName");
        this.testAddress = (String)formParams.getFirst((Object)"testAddress");
        this.recipientOverride = (String)formParams.getFirst((Object)"recipientOverride");
    }

    public UpdateXmppConfigAction(DomainProfileEntity domain, String username, String password, String host, String port, String serviceName, String testAddress, String recipientOverride) {
        this.domain = domain;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.serviceName = serviceName;
        this.testAddress = testAddress;
        this.recipientOverride = recipientOverride;
    }

    public RequestErrors validate(RequestErrors errors) {
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.username, (String)"The user's name must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.password, (String)"The password must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.host, (String)"The host name must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.port, (String)"The port must be specified.");
        return errors;
    }

    public DomainProfileEntity getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRecipientOverride() {
        return this.recipientOverride;
    }

    public String getTestAddress() {
        return this.testAddress;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

