/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.twilio;

import java.util.Map;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidatableAction;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class UpdateTwilioConfigAction
implements ValidatableAction {
    private final DomainProfileEntity domain;
    private final String accountSid;
    private final String authToken;
    private final String testFromNumber;
    private final String testToNumber;

    public UpdateTwilioConfigAction(DomainProfileEntity domain, Map<String, String> params) {
        this.domain = domain;
        this.accountSid = params.get("accountSid");
        this.authToken = params.get("authToken");
        this.testFromNumber = params.get("testFromNumber");
        this.testToNumber = params.get("testToNumber");
    }

    public UpdateTwilioConfigAction(DomainProfileEntity domain, String accountSid, String authToken, String testFromNumber, String testToNumber) {
        this.domain = domain;
        this.accountSid = accountSid;
        this.authToken = authToken;
        this.testFromNumber = testFromNumber;
        this.testToNumber = testToNumber;
    }

    public RequestErrors validate(RequestErrors errors) {
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.accountSid, (String)"The Twilio account SID must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.authToken, (String)"The Twilio Authentication Token must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.testFromNumber, (String)"The Twilio Originating Phone Number must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.testToNumber, (String)"The Twilio SMS Recipient must be specified.");
        return errors;
    }

    public DomainProfileEntity getDomain() {
        return this.domain;
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getTestFromNumber() {
        return this.testFromNumber;
    }

    public String getTestToNumber() {
        return this.testToNumber;
    }
}

