/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.twilio;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.push.kernel.plugins.PluginConfig;
import org.tiogasolutions.push.plugins.twilio.TwilioConfigStore;
import org.tiogasolutions.push.plugins.twilio.UpdateTwilioConfigAction;
import org.tiogasolutions.push.pub.internal.RequestErrors;

@CouchEntity(value="twilio-config")
public class TwilioConfig
implements PluginConfig,
Serializable {
    private String configId;
    private String revision;
    private String domainId;
    private String accountSid;
    private String authToken;
    private String testFromNumber;
    private String testToNumber;

    public TwilioConfig() {
    }

    @JsonCreator
    public TwilioConfig(@JacksonInject(value="configId") String configId, @JacksonInject(value="revision") String revision, @JsonProperty(value="domainId") String domainId, @JsonProperty(value="accountSid") String accountSid, @JsonProperty(value="authToken") String authToken, @JsonProperty(value="testFromNumber") String fromPhoneNumber, @JsonProperty(value="testToNumber") String testToNumber) {
        this.configId = configId;
        this.revision = revision;
        this.domainId = domainId;
        this.accountSid = accountSid;
        this.authToken = authToken;
        this.testFromNumber = fromPhoneNumber;
        this.testToNumber = testToNumber;
    }

    public TwilioConfig apply(UpdateTwilioConfigAction configAction) {
        configAction.validate(new RequestErrors()).assertNoErrors();
        if (this.domainId != null && EqualsUtils.objectsNotEqual((Object)this.domainId, (Object)configAction.getDomain().getDomainId())) {
            String msg = "The specified Update Config Action domain type and this class are not for the same domain.";
            throw new IllegalArgumentException(msg);
        }
        this.domainId = configAction.getDomain().getDomainId();
        this.configId = TwilioConfigStore.toDocumentId(configAction.getDomain());
        this.accountSid = configAction.getAccountSid();
        this.authToken = configAction.getAuthToken();
        this.testFromNumber = configAction.getTestFromNumber();
        this.testToNumber = configAction.getTestToNumber();
        return this;
    }

    @CouchId
    public String getConfigId() {
        return this.configId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getTestFromNumber() {
        return this.testFromNumber;
    }

    public String getTestToNumber() {
        return this.testToNumber;
    }
}

