/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.twilio;

import javax.ws.rs.core.MultivaluedMap;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidatableAction;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class UpdateTwilioConfigAction
implements ValidatableAction {
    private final DomainProfileEntity domain;
    private final String accountSid;
    private final String authToken;
    private final String fromPhoneNumber;
    private final String recipient;

    public UpdateTwilioConfigAction(DomainProfileEntity domain, MultivaluedMap<String, String> formParams) {
        this.domain = domain;
        this.accountSid = (String)formParams.getFirst((Object)"accountSid");
        this.authToken = (String)formParams.getFirst((Object)"authToken");
        this.fromPhoneNumber = (String)formParams.getFirst((Object)"fromPhoneNumber");
        this.recipient = (String)formParams.getFirst((Object)"recipient");
    }

    public UpdateTwilioConfigAction(DomainProfileEntity domain, String accountSid, String authToken, String fromPhoneNumber, String recipient) {
        this.domain = domain;
        this.accountSid = accountSid;
        this.authToken = authToken;
        this.fromPhoneNumber = fromPhoneNumber;
        this.recipient = recipient;
    }

    public RequestErrors validate(RequestErrors errors) {
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.accountSid, (String)"The Twilio account SID must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.authToken, (String)"The Twilio Authentication Token must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.fromPhoneNumber, (String)"The Twilio Originating Phone Number must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.recipient, (String)"The Twilio SMS Recipient must be specified.");
        return errors;
    }

    public DomainProfileEntity getDomain() {
        return this.domain;
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getFromPhoneNumber() {
        return this.fromPhoneNumber;
    }

    public String getRecipient() {
        return this.recipient;
    }
}

