/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.twilio;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.factory.MessageFactory;
import java.util.ArrayList;
import org.apache.http.message.BasicNameValuePair;
import org.tiogasolutions.apis.bitly.BitlyApis;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.jackson.PushObjectMapper;
import org.tiogasolutions.push.kernel.AbstractDelegate;
import org.tiogasolutions.push.kernel.execution.ExecutionContext;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.plugins.twilio.TwilioConfig;
import org.tiogasolutions.push.pub.TwilioSmsPush;
import org.tiogasolutions.push.pub.common.RequestStatus;

public class TwilioDelegate
extends AbstractDelegate {
    private final TwilioSmsPush push;
    private final TwilioConfig config;
    private final BitlyApis bitlyApis;

    public TwilioDelegate(ExecutionContext executionContext, PushObjectMapper objectMapper, PushRequestStore pushRequestStore, BitlyApis bitlyApis, PushRequest pushRequest, TwilioSmsPush push, TwilioConfig config) {
        super(executionContext, objectMapper, pushRequestStore, pushRequest);
        this.config = (TwilioConfig)ExceptionUtils.assertNotNull((Object)config, (String)"config");
        this.push = (TwilioSmsPush)ExceptionUtils.assertNotNull((Object)push, (String)"push");
        this.bitlyApis = bitlyApis;
    }

    public synchronized RequestStatus processRequest() throws Exception {
        TwilioRestClient client = new TwilioRestClient(this.config.getAccountSid(), this.config.getAuthToken());
        String message = this.bitlyApis.parseAndShorten(this.push.getMessage());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("Body", message));
        params.add(new BasicNameValuePair("From", this.push.getFrom()));
        params.add(new BasicNameValuePair("To", this.push.getRecipient()));
        MessageFactory messageFactory = client.getAccount().getMessageFactory();
        messageFactory.create(params);
        return this.pushRequest.processed();
    }
}

