/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.twilio;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.apis.bitly.BitlyApis;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.dev.common.Formats;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.push.jackson.PushObjectMapper;
import org.tiogasolutions.push.kernel.KernelUtils;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionContext;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.PluginSupport;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.plugins.twilio.TwilioConfig;
import org.tiogasolutions.push.plugins.twilio.TwilioConfigStore;
import org.tiogasolutions.push.plugins.twilio.TwilioDelegate;
import org.tiogasolutions.push.plugins.twilio.UpdateTwilioConfigAction;
import org.tiogasolutions.push.pub.TwilioSmsPush;
import org.tiogasolutions.push.pub.common.Push;

@Component
public class TwilioPlugin
extends PluginSupport {
    private final BitlyApis bitlyApis;

    @Autowired
    public TwilioPlugin(ExecutionManager executionManager, PushObjectMapper objectMapper, PushRequestStore pushRequestStore, BitlyApis bitlyApis) {
        super(TwilioSmsPush.PUSH_TYPE, executionManager, objectMapper, pushRequestStore);
        this.bitlyApis = bitlyApis;
    }

    public TwilioConfigStore getConfigStore(ExecutionManager executionManager) {
        return new TwilioConfigStore(executionManager);
    }

    public TwilioConfig getConfig(DomainProfileEntity domainProfile) {
        String docId = TwilioConfigStore.toDocumentId(domainProfile);
        return (TwilioConfig)this.getConfigStore(this.executionManager).getByDocumentId(docId);
    }

    public TwilioDelegate newDelegate(DomainProfileEntity domainProfile, PushRequest pushRequest, Push push) {
        TwilioConfig config = this.getConfig(domainProfile);
        return new TwilioDelegate(this.executionManager.context(), this.objectMapper, this.pushRequestStore, this.bitlyApis, pushRequest, (TwilioSmsPush)push, config);
    }

    public void deleteConfig(DomainProfileEntity domainProfile) {
        TwilioConfig config = this.getConfig(domainProfile);
        if (config != null) {
            this.getConfigStore(this.executionManager).delete(config);
            this.executionManager.context().setLastMessage("Twilio SMS configuration deleted.");
        } else {
            this.executionManager.context().setLastMessage("Twilio SMS configuration doesn't exist.");
        }
    }

    public void updateConfig(DomainProfileEntity domainProfile, MultivaluedMap<String, String> formParams) {
        UpdateTwilioConfigAction action = new UpdateTwilioConfigAction(domainProfile, formParams);
        TwilioConfig twilioConfig = this.getConfig(domainProfile);
        if (twilioConfig == null) {
            twilioConfig = new TwilioConfig();
        }
        twilioConfig.apply(action);
        this.getConfigStore(this.executionManager).update(twilioConfig);
        this.executionManager.context().setLastMessage("Twilio configuration updated.");
    }

    public void test(DomainProfileEntity domainProfile) throws Exception {
        TwilioConfig config = this.getConfig(domainProfile);
        if (config == null) {
            String msg = "The Twilio config has not been specified.";
            this.executionManager.context().setLastMessage(msg);
            return;
        }
        String when = Formats.defaultStamp((Object)new Date());
        TwilioSmsPush push = TwilioSmsPush.newPush((String)config.getFromPhoneNumber(), (String)config.getRecipient(), (String)String.format("Twilio test message from Cosmic Push sent at %s.", when), null, (Map)BeanUtils.toMap((String[])new String[]{"smtp-test:true"}));
        PushRequest pushRequest = new PushRequest(2, domainProfile, (Push)push);
        this.pushRequestStore.create((Object)pushRequest);
        if (new TwilioDelegate(this.executionManager.context(), this.objectMapper, this.pushRequestStore, this.bitlyApis, pushRequest, push, config).execute(false)) {
            String msg = String.format("Test message sent from %s to %s:\n%s", config.getFromPhoneNumber(), config.getRecipient(), push.getMessage());
            this.executionManager.context().setLastMessage(msg);
        }
    }

    public String getAdminUi(DomainProfileEntity domainProfile) throws IOException {
        ExecutionContext context = this.executionManager.context();
        String contextRoot = KernelUtils.getContextRoot((UriInfo)context.getUriInfo());
        TwilioConfig config = this.getConfig(domainProfile);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/org/tiogasolutions/push/plugins/twilio/admin.html");
        String content = IoUtils.toString((InputStream)stream);
        content = content.replace("${legend-class}", StringUtils.nullToString((Object)(config == null ? "no-config" : "")));
        content = content.replace("${push-type}", StringUtils.nullToString((Object)this.getPushType().getCode()));
        content = content.replace("${domain-key}", StringUtils.nullToString((Object)domainProfile.getDomainKey()));
        content = content.replace("${context-root}", StringUtils.nullToString((Object)contextRoot));
        content = content.replace("${config-account-sid}", StringUtils.nullToString((Object)(config == null ? null : config.getAccountSid())));
        content = content.replace("${config-auth-token}", StringUtils.nullToString((Object)(config == null ? null : config.getAuthToken())));
        content = content.replace("${config-from-number}", StringUtils.nullToString((Object)(config == null ? null : config.getFromPhoneNumber())));
        if ((content = content.replace("${config-recipient}", StringUtils.nullToString((Object)(config == null ? null : config.getRecipient())))).contains("${")) {
            String msg = "The Twilio admin UI still contains un-parsed elements.";
            throw new IllegalStateException(msg);
        }
        return content;
    }
}

