/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.twilio;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.factory.MessageFactory;
import java.util.ArrayList;
import org.apache.http.message.BasicNameValuePair;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.common.AbstractDelegate;
import org.tiogasolutions.push.common.clients.Domain;
import org.tiogasolutions.push.common.plugins.PluginContext;
import org.tiogasolutions.push.common.requests.PushRequest;
import org.tiogasolutions.push.plugins.twilio.TwilioConfig;
import org.tiogasolutions.push.pub.TwilioSmsPush;
import org.tiogasolutions.push.pub.common.RequestStatus;

public class TwilioDelegate
extends AbstractDelegate {
    private final Domain domain;
    private final TwilioSmsPush push;
    private final TwilioConfig config;

    public TwilioDelegate(PluginContext pluginContext, Domain domain, PushRequest pushRequest, TwilioSmsPush push, TwilioConfig config) {
        super(pluginContext, pushRequest);
        this.config = (TwilioConfig)ExceptionUtils.assertNotNull((Object)config, (String)"config");
        this.push = (TwilioSmsPush)ExceptionUtils.assertNotNull((Object)push, (String)"push");
        this.domain = (Domain)ExceptionUtils.assertNotNull((Object)domain, (String)"domain");
    }

    public synchronized RequestStatus processRequest() throws Exception {
        TwilioRestClient client = new TwilioRestClient(this.config.getAccountSid(), this.config.getAuthToken());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("Body", this.push.getMessage()));
        params.add(new BasicNameValuePair("From", this.push.getFrom()));
        params.add(new BasicNameValuePair("To", this.push.getRecipient()));
        MessageFactory messageFactory = client.getAccount().getMessageFactory();
        messageFactory.create(params);
        return this.pushRequest.processed();
    }
}

