/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.plugins.twilio;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.factory.MessageFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.message.BasicNameValuePair;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.push.common.clients.Domain;
import org.tiogasolutions.push.common.plugins.PluginContext;
import org.tiogasolutions.push.common.plugins.PluginSupport;
import org.tiogasolutions.push.common.requests.PushRequest;
import org.tiogasolutions.push.common.system.CpCouchServer;
import org.tiogasolutions.push.plugins.twilio.TwilioConfig;
import org.tiogasolutions.push.plugins.twilio.TwilioConfigStore;
import org.tiogasolutions.push.plugins.twilio.TwilioDelegate;
import org.tiogasolutions.push.plugins.twilio.UpdateTwilioConfigAction;
import org.tiogasolutions.push.pub.TwilioSmsPush;
import org.tiogasolutions.push.pub.common.Push;

public class TwilioPlugin
extends PluginSupport {
    private TwilioConfigStore _configStore;

    public TwilioPlugin() {
        super(TwilioSmsPush.PUSH_TYPE);
    }

    public TwilioConfigStore getConfigStore(CpCouchServer couchServer) {
        if (this._configStore == null) {
            this._configStore = new TwilioConfigStore(couchServer);
        }
        return this._configStore;
    }

    public TwilioConfig getConfig(CpCouchServer couchServer, Domain apiClient) {
        String docId = TwilioConfigStore.toDocumentId(apiClient);
        return (TwilioConfig)this.getConfigStore(couchServer).getByDocumentId(docId);
    }

    public TwilioDelegate newDelegate(PluginContext context, Domain domain, PushRequest pushRequest, Push push) {
        TwilioConfig config = this.getConfig(context.getCouchServer(), domain);
        return new TwilioDelegate(context, domain, pushRequest, (TwilioSmsPush)push, config);
    }

    public void deleteConfig(PluginContext context, Domain domain) {
        TwilioConfig config = this.getConfig(context.getCouchServer(), domain);
        if (config != null) {
            this.getConfigStore(context.getCouchServer()).delete(config);
            context.setLastMessage("Twilio SMS configuration deleted.");
        } else {
            context.setLastMessage("Twilio SMS configuration doesn't exist.");
        }
    }

    public void updateConfig(PluginContext context, Domain domain, MultivaluedMap<String, String> formParams) {
        UpdateTwilioConfigAction action = new UpdateTwilioConfigAction(domain, formParams);
        TwilioConfig twilioConfig = this.getConfig(context.getCouchServer(), domain);
        if (twilioConfig == null) {
            twilioConfig = new TwilioConfig();
        }
        twilioConfig.apply(action);
        this.getConfigStore(context.getCouchServer()).update(twilioConfig);
        context.setLastMessage("Twilio configuration updated.");
    }

    public void test(PluginContext context, Domain domain) throws Exception {
        TwilioConfig config = this.getConfig(context.getCouchServer(), domain);
        if (config == null) {
            String msg = "The Twilio config has not been specified.";
            context.setLastMessage(msg);
            return;
        }
        String ACCOUNT_SID = config.getAccountSid();
        String AUTH_TOKEN = config.getAuthToken();
        TwilioRestClient client = new TwilioRestClient(ACCOUNT_SID, AUTH_TOKEN);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("Body", "Twilio test message from Cosmic Push"));
        params.add(new BasicNameValuePair("To", config.getRecipient()));
        params.add(new BasicNameValuePair("From", config.getFromPhoneNumber()));
        MessageFactory messageFactory = client.getAccount().getMessageFactory();
        messageFactory.create(params);
    }

    public String getAdminUi(PluginContext context, Domain domain) throws IOException {
        TwilioConfig config = this.getConfig(context.getCouchServer(), domain);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/org/tiogasolutions/push/plugins/twilio/admin.html");
        String content = IoUtils.toString((InputStream)stream);
        content = content.replace("${legend-class}", StringUtils.nullToString((Object)(config == null ? "no-config" : "")));
        content = content.replace("${push-type}", StringUtils.nullToString((Object)this.getPushType().getCode()));
        content = content.replace("${domain-key}", StringUtils.nullToString((Object)domain.getDomainKey()));
        content = content.replace("${push-server-base}", StringUtils.nullToString((Object)context.getBaseURI()));
        content = content.replace("${config-account-sid}", StringUtils.nullToString((Object)(config == null ? null : config.getAccountSid())));
        content = content.replace("${config-auth-token}", StringUtils.nullToString((Object)(config == null ? null : config.getAuthToken())));
        content = content.replace("${config-from-number}", StringUtils.nullToString((Object)(config == null ? null : config.getFromPhoneNumber())));
        if ((content = content.replace("${config-recipient}", StringUtils.nullToString((Object)(config == null ? null : config.getRecipient())))).contains("${")) {
            String msg = String.format("The Twilio admin UI still contains un-parsed elements.", new Object[0]);
            throw new IllegalStateException(msg);
        }
        return content;
    }
}

