/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.system;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.push.kernel.system.Session;

public class SessionStore {
    public static final String SESSION_COOKIE_NAME = "session-id";
    private static final Object LOCK = new Object();
    private long sessionDuration;
    private Map<String, Session> map = new HashMap<String, Session>();

    public SessionStore(long sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session newSession(String username) {
        this.removeExpiredSessions();
        Object object = LOCK;
        synchronized (object) {
            Session session = new Session(this.sessionDuration, username);
            this.map.put(session.getSessionId(), session);
            return session;
        }
    }

    public long getSessionDuration() {
        return this.sessionDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String sessionId) {
        Object object = LOCK;
        synchronized (object) {
            Session session = this.map.get(sessionId);
            return session != null && session.isNonExpired() ? session : null;
        }
    }

    public void remove(Session session) {
        this.remove(session == null ? null : session.getSessionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String sessionId) {
        if (sessionId == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            this.map.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredSessions() {
        Object object = LOCK;
        synchronized (object) {
            Session[] sessions;
            for (Session session : sessions = (Session[])ReflectUtils.toArray(Session.class, this.map.values())) {
                if (!session.isExpired()) continue;
                this.map.remove(session.getSessionId());
            }
        }
    }

    public boolean isValid(Session session) {
        if (session == null) {
            return false;
        }
        if (session.isExpired()) {
            return false;
        }
        return this.map.containsKey(session.getSessionId());
    }

    public Session getSession(ContainerRequestContext requestContext) {
        Cookie cookie = (Cookie)requestContext.getCookies().get(SESSION_COOKIE_NAME);
        if (cookie == null) {
            return null;
        }
        String sessionId = cookie.getValue();
        return this.getSession(sessionId);
    }

    public static NewCookie toCookie(UriInfo uriInfo, Session session) {
        int maxAge = session == null ? 0 : session.getSecondsToExpire();
        String sessionId = session == null ? null : session.getSessionId();
        String path = uriInfo.getBaseUri().toString();
        int pos = path.indexOf("://");
        if (pos >= 0) {
            pos = path.indexOf("/", pos + 3);
            path = StringUtils.substring((Object)path, (int)pos, (int)-1);
        }
        if (StringUtils.isBlank((Object)path)) {
            path = "/";
        }
        return new NewCookie(SESSION_COOKIE_NAME, sessionId, path, null, null, maxAge, false, true);
    }
}

