/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.system;

import org.tiogasolutions.dev.common.id.uuid.TimeUuid;

public class Session {
    private final String emailAddress;
    private final String sessionId;
    private final long sessionDuration;
    private String lastMessage;
    private long expiresAt;

    public Session(long sessionDuration, String emailAddress) {
        this.emailAddress = emailAddress;
        this.sessionDuration = sessionDuration;
        this.sessionId = TimeUuid.randomUUID().toString();
        this.renew();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public long getSessionDuration() {
        return this.sessionDuration;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public synchronized void renew() {
        this.expiresAt = System.currentTimeMillis() + this.sessionDuration;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.expiresAt;
    }

    public boolean isNonExpired() {
        return System.currentTimeMillis() < this.expiresAt;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public int getSecondsToExpire() {
        long remaining = this.expiresAt - System.currentTimeMillis();
        return (int)(remaining / 1000L);
    }
}

