/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.system;

import com.fasterxml.jackson.databind.Module;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchSetup;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;
import org.tiogasolutions.couchace.jackson.JacksonCouchJsonStrategy;
import org.tiogasolutions.couchace.jersey.JerseyCouchHttpClient;
import org.tiogasolutions.dev.common.id.IdGenerator;
import org.tiogasolutions.dev.common.id.TimeUuidIdGenerator;
import org.tiogasolutions.dev.jackson.TiogaJacksonModule;
import org.tiogasolutions.lib.couchace.DefaultCouchServer;
import org.tiogasolutions.lib.couchace.support.CouchUtils;
import org.tiogasolutions.push.jackson.PushJacksonModule;
import org.tiogasolutions.push.kernel.config.CouchServersConfig;

@Component
public class PushCouchServer
extends DefaultCouchServer {
    @Autowired
    public PushCouchServer(CouchServersConfig config) {
        super(PushCouchServer.createCouchSetup(config));
    }

    public static CouchSetup createCouchSetup(CouchServersConfig config) {
        CouchSetup setup = new CouchSetup(config.getMasterUrl());
        setup.setUserName(config.getMasterUsername());
        setup.setPassword(config.getMasterPassword());
        setup.setHttpClient(JerseyCouchHttpClient.class);
        setup.setJsonStrategy((CouchJsonStrategy)new JacksonCouchJsonStrategy(new Module[]{new TiogaJacksonModule(), new PushJacksonModule()}));
        return setup;
    }

    public static void createMainDatabase(CouchDatabase database) {
        CouchUtils.createDatabase((CouchDatabase)database, (IdGenerator)new TimeUuidIdGenerator(), (String[])new String[]{"/push-server-common/json/account.json"});
        List<String> designNames = Arrays.asList("entity", "domainProfile", "account");
        CouchUtils.validateDesign((CouchDatabase)database, designNames, (String)"/push-server-common/design-docs/", (String)"-design.json");
    }
}

