/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.push.kernel.plugins.Plugin;
import org.tiogasolutions.push.pub.common.PushType;

public class PluginManager {
    private final Map<PushType, Plugin> map = new HashMap<PushType, Plugin>();

    public PluginManager(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            PushType pushType = plugin.getPushType();
            if (this.map.containsKey(pushType)) {
                String msg = String.format("The push type \"%s\" has already been registered.", pushType);
                throw new IllegalArgumentException(msg);
            }
            this.map.put(pushType, plugin);
        }
    }

    public List<Plugin> getPlugins() {
        return new ArrayList<Plugin>(this.map.values());
    }

    public <T extends Plugin> T getPlugin(Class<T> type) {
        for (Plugin plugin : this.map.values()) {
            if (type != plugin.getClass()) continue;
            return (T)plugin;
        }
        return null;
    }

    public Plugin getPlugin(PushType pushType) {
        if (!this.map.containsKey(pushType)) {
            String msg = String.format("The plugin for \"%s\" was not found.", pushType.getCode());
            throw new IllegalArgumentException(msg);
        }
        return this.map.get(pushType);
    }
}

