/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.system;

import java.util.Arrays;
import java.util.List;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.id.IdGenerator;
import org.tiogasolutions.dev.common.id.TimeUuidIdGenerator;
import org.tiogasolutions.lib.couchace.DefaultCouchStore;
import org.tiogasolutions.lib.couchace.support.CouchUtils;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.config.CouchServersConfig;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;

public abstract class DomainSpecificStore<T>
extends DefaultCouchStore<T> {
    private final CouchServersConfig config;
    private final ExecutionManager executionManager;

    public DomainSpecificStore(ExecutionManager executionManager, Class<T> entityType) {
        super(executionManager.getCouchServer(), entityType);
        this.config = executionManager.getCouchServersConfig();
        this.executionManager = executionManager;
    }

    public final String getDatabaseName() {
        DomainProfileEntity domain = this.executionManager.getContext().getDomain();
        if (domain == null) {
            throw ApiException.internalServerError((String)"A domain does not exist within the execution getContext.", (String[])new String[0]);
        }
        return this.config.getDomainDatabasePrefix() + domain.getDomainKey();
    }

    public final void createDatabase(CouchDatabase database) {
        CouchUtils.createDatabase((CouchDatabase)database, (IdGenerator)new TimeUuidIdGenerator(), (String[])new String[0]);
        List<String> designNames = Arrays.asList("entity", "push-request");
        CouchUtils.validateDesign((CouchDatabase)database, designNames, (String)"/push-server-common/design-docs/", (String)"-design.json");
    }
}

