/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.requests;

import java.util.List;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.http.CouchHttpException;
import org.tiogasolutions.couchace.core.api.query.CouchPageNavigation;
import org.tiogasolutions.couchace.core.api.query.CouchPageQuery;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.response.EntityDocument;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;

public class QueryResult<T> {
    private final Class<T> type;
    private final CouchDatabase database;
    private GetEntityResponse<T> response;

    public QueryResult(Class<T> type, CouchDatabase database, CouchViewQuery viewQuery) {
        this.type = type;
        this.database = database;
        this.response = database.get().entity(type, viewQuery).execute();
        QueryResult.validate(this.response);
    }

    public List<T> getEntityList() {
        return this.response.getEntityList();
    }

    public List<EntityDocument<T>> getDocumentList() {
        return this.response.getDocumentList();
    }

    public int getSize() {
        return this.response.getSize();
    }

    public boolean hasNextPage() {
        return this.response.getCouchPageNavigation().hasNextPage();
    }

    public boolean nextPage() {
        boolean hasNext = this.hasNextPage();
        if (hasNext) {
            CouchPageNavigation pageNavigation = this.response.getCouchPageNavigation();
            CouchPageQuery nextPageQuery = pageNavigation.queryNextPage();
            this.response = this.database.get().entity(this.type, nextPageQuery).execute();
            QueryResult.validate(this.response);
        }
        return hasNext;
    }

    public boolean hasPrevPage() {
        return this.response.getCouchPageNavigation().hasPreviousPage();
    }

    public boolean prevPage() {
        boolean hasPrev = this.hasPrevPage();
        if (hasPrev) {
            CouchPageNavigation pageNavigation = this.response.getCouchPageNavigation();
            CouchPageQuery prevPageQuery = pageNavigation.queryPreviousPage();
            this.response = this.database.get().entity(this.type, prevPageQuery).execute();
            QueryResult.validate(this.response);
        }
        return hasPrev;
    }

    private static void validate(GetEntityResponse response) {
        if (!response.isOk()) {
            throw new CouchHttpException(response.getHttpStatus(), "Unexpected response while executing couch query.");
        }
    }
}

